/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.less;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.ConfigurationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.PostInitializationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.less.ILessCssResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.less.LessEngine;
import net.jawr.web.resource.bundle.generator.css.less.LessException;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;

public class LessCssGenerator
extends AbstractCSSGenerator
implements ILessCssResourceGenerator,
ConfigurationAwareResourceGenerator,
PostInitializationAwareResourceGenerator {
    private static final String LESS_SCRIPT_LOCATION_PROPERTY_NAME = "jawr.css.less.generator.less.script.location";
    private static final String DEFAULT_LESS_SCRIPT_LOCATION = "net/jawr/web/resource/bundle/generator/css/less/less.js";
    private static final String LESS_ENGINE_SCRIPT_LOCATION_PROPERTY_NAME = "jawr.css.less.generator.engine.script.location";
    private static final String DEFAULT_ENGINE_JS_LOCATION = "net/jawr/web/resource/bundle/generator/css/less/engine.js";
    private static final String BROWSER_SCRIPT_LOCATION_PROPERTY_NAME = "jawr.css.less.generator.browser.script.location";
    private static final String DEFAULT_BROWSER_JS_LOCATION = "net/jawr/web/resource/bundle/generator/css/less/browser.js";
    private static final String LESS_SUFFIX = "less";
    private ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createSuffixResolver("less");
    private LessEngine engine;
    private JawrConfig config;

    @Override
    public void setConfig(JawrConfig config) {
        this.config = config;
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public void afterPropertiesSet() {
        String lessScript = this.config.getProperty(LESS_SCRIPT_LOCATION_PROPERTY_NAME, DEFAULT_LESS_SCRIPT_LOCATION);
        InputStream isLessScript = this.getResourceInputStream(lessScript);
        String engineScript = this.config.getProperty(LESS_ENGINE_SCRIPT_LOCATION_PROPERTY_NAME, DEFAULT_ENGINE_JS_LOCATION);
        InputStream isEngineScript = this.getResourceInputStream(engineScript);
        String browserScript = this.config.getProperty(BROWSER_SCRIPT_LOCATION_PROPERTY_NAME, DEFAULT_BROWSER_JS_LOCATION);
        InputStream isBrowserScript = this.getResourceInputStream(browserScript);
        this.engine = new LessEngine(isLessScript, isEngineScript, isBrowserScript);
    }

    public InputStream getResourceInputStream(String path) {
        InputStream is = this.config.getContext().getResourceAsStream(path);
        if (is == null) {
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException(e);
            }
        }
        return is;
    }

    @Override
    protected Reader generateResourceForBundle(GeneratorContext context) {
        String path = context.getPath();
        Reader rd = null;
        try {
            ArrayList excluded = new ArrayList();
            excluded.add(ILessCssResourceGenerator.class);
            rd = context.getResourceReaderHandler().getResource(path, false, excluded);
            if (rd == null) {
                throw new ResourceNotFoundException(path);
            }
            StringWriter swr = new StringWriter();
            IOUtils.copy(rd, (Writer)swr);
            String result = this.compile(path, swr.toString());
            rd = new StringReader(result);
        }
        catch (ResourceNotFoundException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
        return rd;
    }

    public String compile(String path, String content) {
        try {
            return this.engine.compile(content);
        }
        catch (LessException e) {
            throw new RuntimeException("Problem compiling Less CSS from Resource '" + path + "'", e);
        }
    }
}

