/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.less;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.jawr.web.resource.bundle.generator.css.less.LessException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessEngine {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Scriptable scope;
    private Function cs;

    public LessEngine() {
        this(LessEngine.class.getResourceAsStream("less.js"), LessEngine.class.getResourceAsStream("engine.js"), LessEngine.class.getResourceAsStream("browser.js"));
    }

    public LessEngine(InputStream less, InputStream engine, InputStream browser) {
        try {
            this.logger.debug("Initializing LESS Engine.");
            Context cx = Context.enter();
            this.logger.warn("Using implementation version: " + cx.getImplementationVersion());
            cx.setOptimizationLevel(9);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(browser), "browser.js", 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(less), "less.js", 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(engine), "engine.js", 1, null);
            this.cs = (Function)this.scope.get("compileString", this.scope);
            Context.exit();
        }
        catch (Exception e) {
            this.logger.error("LESS Engine intialization failed.", (Throwable)e);
        }
    }

    public String compile(String input) throws LessException {
        try {
            long time = System.currentTimeMillis();
            String result = this.call(this.cs, new Object[]{input});
            this.logger.debug("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms.");
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    private synchronized String call(Function fn, Object[] args) {
        return (String)Context.call(null, (Callable)fn, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])args);
    }

    private LessException parseLessException(Exception root) throws LessException {
        this.logger.debug("Parsing LESS Exception", (Throwable)root);
        if (root instanceof JavaScriptException) {
            Scriptable value = (Scriptable)((JavaScriptException)root).getValue();
            boolean hasName = ScriptableObject.hasProperty((Scriptable)value, (String)"name");
            boolean hasType = ScriptableObject.hasProperty((Scriptable)value, (String)"type");
            if (hasName || hasType) {
                Object prop;
                String errorType = "Error";
                if (hasName) {
                    String type = (String)ScriptableObject.getProperty((Scriptable)value, (String)"name");
                    errorType = "ParseError".equals(type) ? "Parse Error" : type + " Error";
                } else if (hasType && (prop = ScriptableObject.getProperty((Scriptable)value, (String)"type")) instanceof String) {
                    errorType = (String)prop + " Error";
                }
                String message = ScriptableObject.getProperty((Scriptable)value, (String)"message").toString();
                String filename = "";
                if (ScriptableObject.getProperty((Scriptable)value, (String)"filename") != null) {
                    filename = ScriptableObject.getProperty((Scriptable)value, (String)"filename").toString();
                }
                int line = -1;
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"line")) {
                    line = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"line")).intValue();
                }
                int column = -1;
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"column")) {
                    column = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"column")).intValue();
                }
                ArrayList<String> extractList = new ArrayList<String>();
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"extract")) {
                    NativeArray extract = (NativeArray)ScriptableObject.getProperty((Scriptable)value, (String)"extract");
                    int i = 0;
                    while ((long)i < extract.getLength()) {
                        if (extract.get(i, (Scriptable)extract) instanceof String) {
                            extractList.add(((String)extract.get(i, (Scriptable)extract)).replace("\t", " "));
                        }
                        ++i;
                    }
                }
                throw new LessException(message.toString(), errorType, filename, line, column, extractList);
            }
        }
        throw new LessException(root);
    }
}

