/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.resolver;

import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.util.StringUtils;

public class PrefixedPathResolver
implements ResourceGeneratorResolver {
    public static final String PREFIX_SEPARATOR = ":";
    private String prefix;
    private boolean skipPrefix;

    public PrefixedPathResolver(String prefix) {
        this(prefix, PREFIX_SEPARATOR, true);
    }

    public PrefixedPathResolver(String prefix, String separator) {
        this(prefix, separator, true);
    }

    public PrefixedPathResolver(String prefix, String separator, boolean skipPrefix) {
        this.prefix = prefix + separator;
        this.skipPrefix = skipPrefix;
    }

    @Override
    public boolean matchPath(String path) {
        boolean match = false;
        if (StringUtils.isNotEmpty(path)) {
            match = path.startsWith(this.prefix);
        }
        return match;
    }

    @Override
    public boolean isSameAs(ResourceGeneratorResolver matcher) {
        return this.equals(matcher);
    }

    @Override
    public String getResourcePath(String requestedPath) {
        String resourcePath = requestedPath;
        if (this.skipPrefix) {
            resourcePath = requestedPath.substring(this.prefix.length());
        }
        return resourcePath;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixedPathResolver)) {
            return false;
        }
        PrefixedPathResolver other = (PrefixedPathResolver)obj;
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }
}

