/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.global.postprocessor.google.closure;

import com.google.common.io.CharStreams;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.global.postprocessor.GlobalPostProcessingContext;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.global.processor.AbstractChainedGlobalProcessor;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.util.FileUtils;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureGlobalPostProcessor
extends AbstractChainedGlobalProcessor<GlobalPostProcessingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClosureGlobalPostProcessor.class);
    private List<String> UNALLOWED_COMPILER_ARGS = Arrays.asList("js", "module");
    private static final String CLOSURE_ARGUMENT_NAME_PREFIX = "--";
    private static final String JAWR_JS_CLOSURE_PREFIX = "jawr.js.closure.";
    private static final String MODULE_ARG = "--module";
    private static final Pattern MODULE_ARG_PATTERN = Pattern.compile("[^:]+:\\d+:(.*)");
    private static final String MODULE_DEPENDENCIES_SEPARATOR = ",";
    private static final String JS_ARG = "--js";
    private static final String COMPILATION_LEVEL = "compilation_level";
    private static final String COMPILATION_LEVEL_ARG = "--compilation_level";
    private static final String WHITESPACE_ONLY_COMPILATION_LEVEL = "WHITESPACE_ONLY";
    private static final String SIMPLE_OPTIMIZATIONS_COMPILATION_LEVEL = "SIMPLE_OPTIMIZATIONS";
    private static final String ADVANCED_OPTIMIZATIONS_COMPILATION_LEVEL = "ADVANCED_OPTIMIZATIONS";
    private static final String WARNING_LEVEL_ARG = "--warning_level";
    private static final String VERBOSE_WARNING_LEVEL = "VERBOSE";
    private static final String JAWR_JS_CLOSURE_BUNDLES_EXCLUDED = "jawr.js.closure.bundles.excluded";
    private static final String JAWR_JS_CLOSURE_DISABLE_THREAD = "jawr.js.closure.disableThread";
    private static final String JAWR_JS_CLOSURE_MODULES = "jawr.js.closure.modules";
    private static final List<String> JAWR_JS_CLOSURE_SPECIFIC_PROPERTIES = Arrays.asList("jawr.js.closure.bundles.excluded", "jawr.js.closure.disableThread", "jawr.js.closure.modules");
    private static final String GOOGLE_CLOSURE_TEMP_DIR = "/googleClosure/temp/";
    private static final String GOOGLE_CLOSURE_RESULT_DIR = "/googleClosure/result/";
    private static final String JAWR_ROOT_MODULE_JS = "/JAWR_ROOT_MODULE.js";
    private static final String JAWR_ROOT_MODULE_NAME = "JAWR_ROOT_MODULE";
    private String srcDir;
    private String destDir;
    private String tempDir;

    public ClosureGlobalPostProcessor() {
        super("closure");
    }

    public ClosureGlobalPostProcessor(String srcDir, String tempDir, String destDir) {
        super("closure");
        this.srcDir = srcDir;
        this.destDir = destDir;
        this.tempDir = tempDir;
    }

    @Override
    public void processBundles(GlobalPostProcessingContext ctx, List<JoinableResourceBundle> bundles) {
        if (ctx.hasBundleToBeProcessed()) {
            File dir;
            String workingDir = ctx.getRsReaderHandler().getWorkingDirectory();
            if (this.srcDir == null || this.destDir == null || this.tempDir == null) {
                this.srcDir = ctx.getBundleHandler().getBundleTextDirPath();
                this.destDir = workingDir + GOOGLE_CLOSURE_RESULT_DIR;
                this.tempDir = workingDir + GOOGLE_CLOSURE_TEMP_DIR;
            }
            if (!(dir = new File(this.destDir)).exists() && !dir.mkdirs()) {
                throw new BundlingProcessException("Impossible to create temprary directory :" + this.destDir);
            }
            dir = new File(this.tempDir);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new BundlingProcessException("Impossible to create temprary directory :" + this.tempDir);
            }
            try {
                FileUtils.copyDirectory(new File(this.srcDir), new File(this.tempDir));
                HashMap<String, String> resultBundleMapping = new HashMap<String, String>();
                JawrClosureCommandLineRunner cmdRunner = new JawrClosureCommandLineRunner(ctx, bundles, resultBundleMapping);
                cmdRunner.doRun();
                FileUtils.copyDirectory(new File(this.destDir), new File(this.srcDir));
            }
            catch (Exception e) {
                throw new BundlingProcessException(e);
            }
        }
    }

    private String[] getClosureCompilerArgs(GlobalPostProcessingContext ctx, List<JoinableResourceBundle> tmpBundles, Map<String, String> resultBundlePathMapping) {
        ArrayList<String> args = new ArrayList<String>();
        JawrConfig config = ctx.getJawrConfig();
        ArrayList<JoinableResourceBundle> bundles = new ArrayList<JoinableResourceBundle>(tmpBundles);
        this.initCompilerClosureArgumentsFromConfig(args, config);
        String excludedBundlesProp = config.getProperty(JAWR_JS_CLOSURE_BUNDLES_EXCLUDED, "");
        List<String> excludedBundles = Arrays.asList(excludedBundlesProp.replaceAll(" ", "").split(MODULE_DEPENDENCIES_SEPARATOR));
        HashMap<String, JoinableResourceBundle> bundleMap = new HashMap<String, JoinableResourceBundle>();
        for (JoinableResourceBundle bundle : bundles) {
            if (excludedBundles.contains(bundle.getName())) continue;
            bundleMap.put(bundle.getName(), bundle);
        }
        String modules = config.getProperty(JAWR_JS_CLOSURE_MODULES);
        ArrayList<String> depModulesArgs = new ArrayList<String>();
        List<String> globalBundleDependencies = this.getGlobalBundleDependencies(ctx, excludedBundles);
        this.initModulesArgs(resultBundlePathMapping, args, bundles, bundleMap, modules, depModulesArgs, globalBundleDependencies);
        for (JoinableResourceBundle bundle : bundles) {
            if (excludedBundles.contains(bundle.getName())) continue;
            this.generateBundleModuleArgs(args, bundleMap, resultBundlePathMapping, bundle, globalBundleDependencies);
        }
        args.addAll(depModulesArgs);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder strArg = new StringBuilder();
            for (String arg : args) {
                strArg.append(arg + " ");
            }
            LOGGER.debug("Closure Compiler Args : " + strArg.toString());
        }
        return args.toArray(new String[0]);
    }

    private List<String> getGlobalBundleDependencies(GlobalPostProcessingContext ctx, List<String> excludedBundles) {
        List<JoinableResourceBundle> globalBundles = this.getRsBundlesHandler(ctx).getGlobalBundles();
        ArrayList<String> globalBundleDependencies = new ArrayList<String>();
        for (JoinableResourceBundle globalBundle : globalBundles) {
            if (excludedBundles.contains(globalBundle.getName())) continue;
            globalBundleDependencies.add(globalBundle.getName());
        }
        return globalBundleDependencies;
    }

    private void initCompilerClosureArgumentsFromConfig(List<String> args, JawrConfig config) {
        Set<Map.Entry<Object, Object>> entrySet = config.getConfigProperties().entrySet();
        for (Map.Entry<Object, Object> propEntry : entrySet) {
            String key = (String)propEntry.getKey();
            if (!key.startsWith(JAWR_JS_CLOSURE_PREFIX) || JAWR_JS_CLOSURE_SPECIFIC_PROPERTIES.contains(key)) continue;
            String compilerArgName = key.substring(JAWR_JS_CLOSURE_PREFIX.length());
            this.checkCompilerArgumentName(compilerArgName);
            String compilerArgValue = (String)propEntry.getValue();
            compilerArgValue = this.getCompilerArgValue(compilerArgName, compilerArgValue);
            args.add(CLOSURE_ARGUMENT_NAME_PREFIX + compilerArgName);
            args.add(propEntry.getValue().toString());
        }
        if (!args.contains(COMPILATION_LEVEL_ARG)) {
            args.add(COMPILATION_LEVEL_ARG);
            args.add(WHITESPACE_ONLY_COMPILATION_LEVEL);
        }
        if (!args.contains(WARNING_LEVEL_ARG)) {
            args.add(WARNING_LEVEL_ARG);
            args.add(VERBOSE_WARNING_LEVEL);
        }
    }

    private void initModulesArgs(Map<String, String> resultBundlePathMapping, List<String> args, List<JoinableResourceBundle> bundles, Map<String, JoinableResourceBundle> bundleMap, String modules, List<String> depModulesArgs, List<String> globalBundleDependencies) {
        args.add(JS_ARG);
        args.add(JAWR_ROOT_MODULE_JS);
        args.add(MODULE_ARG);
        args.add("JAWR_ROOT_MODULE:1:");
        resultBundlePathMapping.put(JAWR_ROOT_MODULE_NAME, JAWR_ROOT_MODULE_JS);
        if (StringUtils.isNotEmpty(modules)) {
            String[] moduleSpecs;
            for (String moduleSpec : moduleSpecs = modules.split(";")) {
                int moduleNameSeparatorIdx = moduleSpec.indexOf(":");
                if (moduleNameSeparatorIdx < 0) {
                    throw new BundlingProcessException("The property 'jawr.js.closure.modules' is not properly defined. Please check your configuration.");
                }
                String bundleName = moduleSpec.substring(0, moduleNameSeparatorIdx);
                this.checkBundleName(bundleName, bundleMap);
                JoinableResourceBundle bundle = bundleMap.get(bundleName);
                List<String> dependencies = Arrays.asList(moduleSpec.substring(moduleNameSeparatorIdx + 1).split(MODULE_DEPENDENCIES_SEPARATOR));
                dependencies.addAll(0, globalBundleDependencies);
                this.generateBundleModuleArgs(depModulesArgs, bundleMap, resultBundlePathMapping, bundle, dependencies);
                bundles.remove(bundle);
            }
        }
    }

    private void checkCompilerArgumentName(String compilerArgName) {
        if (this.UNALLOWED_COMPILER_ARGS.contains(compilerArgName)) {
            throw new BundlingProcessException("The usage of the closure argument '" + compilerArgName + "' is not allowed.");
        }
    }

    private String getCompilerArgValue(String compilerArgName, String compilerArgValue) {
        if (compilerArgName.equals(COMPILATION_LEVEL)) {
            if (!(ADVANCED_OPTIMIZATIONS_COMPILATION_LEVEL.equalsIgnoreCase(compilerArgValue) || WHITESPACE_ONLY_COMPILATION_LEVEL.equalsIgnoreCase(compilerArgValue) || SIMPLE_OPTIMIZATIONS_COMPILATION_LEVEL.equalsIgnoreCase(compilerArgValue))) {
                if (StringUtils.isNotEmpty(compilerArgValue)) {
                    LOGGER.debug("Closure compilation level defined in config '" + compilerArgValue + "' is not part of the available " + "ones [WHITESPACE_ONLY, SIMPLE_OPTIMIZATIONS, ADVANCED_OPTIMIZATIONS");
                }
                compilerArgValue = WHITESPACE_ONLY_COMPILATION_LEVEL;
            }
            LOGGER.debug("Closure compilation level used : " + compilerArgValue);
        }
        return compilerArgValue;
    }

    private void generateBundleModuleArgs(List<String> args, Map<String, JoinableResourceBundle> bundleMap, Map<String, String> resultBundleMapping, JoinableResourceBundle bundle, List<String> dependencies) {
        Set<String> bundleDependencies = this.getClosureModuleDependencies(bundle, dependencies);
        Map<String, VariantSet> bundleVariants = bundle.getVariants();
        List<Map<String, String>> variants = VariantUtils.getAllVariants(bundleVariants);
        if (variants.isEmpty()) {
            variants.add(null);
        }
        for (Map<String, String> variant : variants) {
            String jsFile = VariantUtils.getVariantBundleName(bundle.getId(), variant);
            String moduleName = VariantUtils.getVariantBundleName(bundle.getName(), variant);
            resultBundleMapping.put(moduleName, jsFile);
            StringBuilder moduleArg = new StringBuilder();
            moduleArg.append(moduleName + ":1:");
            for (String dep : bundleDependencies) {
                this.checkBundleName(dep, bundleMap);
                JoinableResourceBundle dependencyBundle = bundleMap.get(dep);
                List<String> depVariantKeys = VariantUtils.getAllVariantKeysFromFixedVariants(dependencyBundle.getVariants(), variant);
                for (String depVariantKey : depVariantKeys) {
                    String depBundleName = VariantUtils.getVariantBundleName(dep, depVariantKey);
                    moduleArg.append(depBundleName);
                    moduleArg.append(MODULE_DEPENDENCIES_SEPARATOR);
                }
            }
            moduleArg.append(JAWR_ROOT_MODULE_NAME);
            this.addModuleArg(jsFile, moduleName, args, moduleArg);
        }
    }

    protected void addModuleArg(String jsFile, String moduleName, List<String> args, StringBuilder moduleArg) {
        int argIdx = 0;
        Iterator<String> iterArg = args.iterator();
        while (iterArg.hasNext()) {
            String arg = iterArg.next();
            if (arg.equals(JS_ARG)) {
                iterArg.next();
                arg = iterArg.next();
                argIdx += 2;
            }
            if (arg.equals(MODULE_ARG)) {
                arg = iterArg.next();
                ++argIdx;
                Matcher matcher = MODULE_ARG_PATTERN.matcher(arg);
                if (matcher.find()) {
                    List<String> moduleDepdendencies;
                    String dep = matcher.group(1);
                    if (dep != null && (moduleDepdendencies = Arrays.asList(dep.split(MODULE_DEPENDENCIES_SEPARATOR))).contains(moduleName)) {
                        break;
                    }
                } else {
                    throw new BundlingProcessException("There were an error in the generation of the module dependencies.");
                }
            }
            ++argIdx;
        }
        args.add(argIdx++, JS_ARG);
        args.add(argIdx++, jsFile);
        args.add(argIdx++, MODULE_ARG);
        args.add(argIdx++, moduleArg.toString());
    }

    private Set<String> getClosureModuleDependencies(JoinableResourceBundle bundle, List<String> dependencies) {
        HashSet<String> bundleDependencies = new HashSet<String>();
        if (bundle.getDependencies() != null) {
            for (JoinableResourceBundle depBundle : bundle.getDependencies()) {
                bundleDependencies.add(depBundle.getName());
            }
        }
        for (String depBundleName : dependencies) {
            if (bundle.getInclusionPattern().isGlobal() && depBundleName.equals(bundle.getName())) break;
            bundleDependencies.add(depBundleName);
        }
        return bundleDependencies;
    }

    private void checkBundleName(String bundleName, Map<String, JoinableResourceBundle> bundleMap) {
        if (!JAWR_ROOT_MODULE_NAME.equals(bundleName)) {
            boolean moduleExist;
            boolean bl = moduleExist = bundleMap.get(bundleName) != null;
            if (!moduleExist) {
                throw new BundlingProcessException("The bundle name '" + bundleName + "' defined in 'jawr.js.closure.modules' is not defined in the configuration. Please check your configuration.");
            }
        }
    }

    public ResourceBundlesHandler getRsBundlesHandler(GlobalPostProcessingContext ctx) {
        return ctx.getBundleHandler();
    }

    private class JawrClosureCommandLineRunner
    extends CommandLineRunner {
        private GlobalPostProcessingContext ctx;
        private Map<String, String> resultBundleMapping;

        public JawrClosureCommandLineRunner(GlobalPostProcessingContext ctx, List<JoinableResourceBundle> bundles, Map<String, String> resultBundleMapping) {
            super(ClosureGlobalPostProcessor.this.getClosureCompilerArgs(ctx, bundles, resultBundleMapping));
            this.ctx = ctx;
            this.resultBundleMapping = resultBundleMapping;
        }

        protected Compiler createCompiler() {
            Compiler compiler = new Compiler(this.getErrorPrintStream());
            if (Boolean.getBoolean(this.ctx.getJawrConfig().getProperty(ClosureGlobalPostProcessor.JAWR_JS_CLOSURE_DISABLE_THREAD, "false"))) {
                compiler.disableThreads();
            }
            return compiler;
        }

        protected void checkModuleName(String name) throws AbstractCommandLineRunner.FlagUsageException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<SourceFile> createInputs(List<String> files, boolean allowStdIn) throws IOException {
            ArrayList<SourceFile> inputs = new ArrayList<SourceFile>(files.size());
            for (String filename : files) {
                if (filename.equals(ClosureGlobalPostProcessor.JAWR_ROOT_MODULE_JS)) {
                    SourceFile newFile = SourceFile.fromCode((String)filename, (String)"");
                    inputs.add(newFile);
                    continue;
                }
                if ("-".equals(filename)) continue;
                Reader rd = null;
                StringWriter swr = new StringWriter();
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(new File(ClosureGlobalPostProcessor.this.tempDir, filename));
                        rd = Channels.newReader(Channels.newChannel(is), this.ctx.getJawrConfig().getResourceCharset().displayName());
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    if (rd == null) {
                        try {
                            rd = this.ctx.getRsReaderHandler().getResource(filename);
                        }
                        catch (ResourceNotFoundException e1) {
                            throw new BundlingProcessException(e1);
                        }
                    }
                    String jsCode = CharStreams.toString(rd);
                    SourceFile newFile = SourceFile.fromCode((String)filename, (String)jsCode);
                    inputs.add(newFile);
                }
                catch (Throwable throwable) {
                    IOUtils.close(is);
                    IOUtils.close(rd);
                    IOUtils.close(swr);
                    throw throwable;
                }
                IOUtils.close(is);
                IOUtils.close(rd);
                IOUtils.close(swr);
            }
            return inputs;
        }

        protected OutputStream filenameToOutputStream(String fileName) throws IOException {
            if (fileName == null) {
                return null;
            }
            int fileExtensionIdx = fileName.lastIndexOf(".");
            String bundleName = fileName.substring(0, fileExtensionIdx).substring(2);
            String bundlePath = this.resultBundleMapping.get(bundleName);
            bundlePath = PathNormalizer.escapeToPhysicalPath(bundlePath);
            File outFile = new File(ClosureGlobalPostProcessor.this.destDir, bundlePath);
            outFile.getParentFile().mkdirs();
            return new FileOutputStream(outFile);
        }

        public int doRun() throws AbstractCommandLineRunner.FlagUsageException, IOException {
            int result = super.doRun();
            File jawrRootModuleFile = new File(ClosureGlobalPostProcessor.this.destDir, this.resultBundleMapping.get(ClosureGlobalPostProcessor.JAWR_ROOT_MODULE_NAME));
            if (!jawrRootModuleFile.delete()) {
                LOGGER.warn("Enable to delete JAWR_ROOT_MODULE.js file");
            }
            return result;
        }
    }
}

