/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.global.preprocessor.css.smartsprites;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.resource.ResourceHandler;

public class SmartSpritesResourceHandler
implements ResourceHandler {
    private ResourceReaderHandler rsHandler;
    private ResourceReaderHandler imgRsHandler;
    private GeneratorRegistry cssGeneratorRegistry;
    private GeneratorRegistry imgGeneratorRegistry;
    private final String charset;
    private final String workingDir;
    private String contextPath = null;

    public SmartSpritesResourceHandler(ResourceReaderHandler rsHandler, ResourceReaderHandler imgRsHandler, GeneratorRegistry cssGeneratorRegistry, GeneratorRegistry imgGeneratorRegistry, String charset, MessageLog messageLog) {
        this.rsHandler = rsHandler;
        this.imgRsHandler = imgRsHandler;
        this.cssGeneratorRegistry = cssGeneratorRegistry;
        this.imgGeneratorRegistry = imgGeneratorRegistry;
        this.charset = charset;
        this.workingDir = rsHandler.getWorkingDirectory() + "/cssSprites/src/";
    }

    public void setContextPath(String contextPath) {
        if (contextPath != null && !contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        this.contextPath = contextPath;
    }

    public Reader getResourceAsReader(String resourceName) throws IOException {
        try {
            return this.rsHandler.getResource(resourceName, true);
        }
        catch (ResourceNotFoundException e) {
            throw new IOException("The resource '" + resourceName + "' was not found.");
        }
    }

    public InputStream getResourceAsInputStream(String resourceName) throws IOException {
        try {
            return this.imgRsHandler.getResourceAsStream(resourceName);
        }
        catch (ResourceNotFoundException e) {
            throw new IOException("The resource '" + resourceName + "' was not found.");
        }
    }

    public String getResourcePath(String basePath, String relativePath) {
        String result = null;
        result = this.imgGeneratorRegistry.isGeneratedImage(relativePath) ? relativePath : (this.contextPath != null && relativePath.startsWith(this.contextPath) ? relativePath.substring(this.contextPath.length() - 1) : PathNormalizer.concatWebPath(basePath, relativePath));
        return result;
    }

    public OutputStream getResourceAsOutputStream(String resourceName) throws IOException {
        String generatedFilePath = resourceName.substring(this.workingDir.length());
        generatedFilePath = !FileNameUtils.isExtension(generatedFilePath, "css") && this.imgGeneratorRegistry.isGeneratedImage(generatedFilePath) ? this.workingDir + "/generatedSpriteImg/" + generatedFilePath.replace(':', '/') : (this.cssGeneratorRegistry.isPathGenerated(generatedFilePath) ? this.workingDir + "/generatedCss/" + generatedFilePath.replace(':', '/') : resourceName);
        File parentFile = new File(generatedFilePath).getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Unable to create the directory : " + parentFile.getPath());
        }
        File file = new File(generatedFilePath);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            file = file.getAbsoluteFile();
        }
        return new FileOutputStream(file);
    }

    public Writer getResourceAsWriter(String path) throws IOException {
        try {
            return new OutputStreamWriter(this.getResourceAsOutputStream(path), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new BundlingProcessException(e);
        }
    }
}

