/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.handler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;
import net.jawr.web.DebugMode;
import net.jawr.web.cache.CacheManagerFactory;
import net.jawr.web.cache.JawrCacheManager;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.handler.ClientSideHandlerGenerator;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.iterator.ConditionalCommentCallbackHandler;
import net.jawr.web.resource.bundle.iterator.ResourceBundlePathsIterator;

public class CachedResourceBundlesHandler
implements ResourceBundlesHandler {
    private static String TEXT_CACHE_PREFIX = "TEXT.";
    private static String ZIP_CACHE_PREFIX = "ZIP.";
    private ResourceBundlesHandler rsHandler;
    private JawrCacheManager cacheMgr;

    public CachedResourceBundlesHandler(ResourceBundlesHandler rsHandler) {
        this.rsHandler = rsHandler;
        this.cacheMgr = CacheManagerFactory.getCacheManager(rsHandler.getConfig(), rsHandler.getResourceType());
    }

    @Override
    public String getResourceType() {
        return this.rsHandler.getResourceType();
    }

    @Override
    public List<JoinableResourceBundle> getGlobalBundles() {
        return this.rsHandler.getGlobalBundles();
    }

    @Override
    public List<JoinableResourceBundle> getContextBundles() {
        return this.rsHandler.getContextBundles();
    }

    @Override
    public ResourceBundlePathsIterator getBundlePaths(String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.rsHandler.getBundlePaths(bundleId, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getBundlePaths(DebugMode debugMode, String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.rsHandler.getBundlePaths(debugMode, bundleId, commentCallbackHandler, variants);
    }

    @Override
    public JawrConfig getConfig() {
        return this.rsHandler.getConfig();
    }

    @Override
    public void initAllBundles() {
        this.rsHandler.initAllBundles();
    }

    @Override
    public JoinableResourceBundle resolveBundleForPath(String path) {
        return this.rsHandler.resolveBundleForPath(path);
    }

    @Override
    public void streamBundleTo(String bundlePath, OutputStream out) throws ResourceNotFoundException {
        try {
            byte[] gzip = (byte[])this.cacheMgr.get(ZIP_CACHE_PREFIX + bundlePath);
            if (null == gzip) {
                ByteArrayOutputStream baOs = new ByteArrayOutputStream();
                BufferedOutputStream bfOs = new BufferedOutputStream(baOs);
                this.rsHandler.streamBundleTo(bundlePath, bfOs);
                bfOs.close();
                gzip = baOs.toByteArray();
                this.cacheMgr.put(ZIP_CACHE_PREFIX + bundlePath, gzip);
            }
            IOUtils.write(gzip, out);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException writing bundle[" + bundlePath + "]", e);
        }
    }

    @Override
    public void writeBundleTo(String bundlePath, Writer writer) throws ResourceNotFoundException {
        String text = (String)this.cacheMgr.get(TEXT_CACHE_PREFIX + bundlePath);
        try {
            if (null == text) {
                String charsetName = this.rsHandler.getConfig().getResourceCharset().name();
                ByteArrayOutputStream baOs = new ByteArrayOutputStream();
                WritableByteChannel wrChannel = Channels.newChannel(baOs);
                Writer tempWriter = Channels.newWriter(wrChannel, charsetName);
                this.rsHandler.writeBundleTo(bundlePath, tempWriter);
                text = baOs.toString(charsetName);
                this.cacheMgr.put(TEXT_CACHE_PREFIX + bundlePath, text);
            }
            writer.write(text);
            writer.flush();
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException writing bundle[" + bundlePath + "]", e);
        }
    }

    @Override
    public ClientSideHandlerGenerator getClientSideHandler() {
        return this.rsHandler.getClientSideHandler();
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.rsHandler.getGlobalResourceBundlePaths(bundleId, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(DebugMode debugMode, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.rsHandler.getGlobalResourceBundlePaths(debugMode, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.rsHandler.getGlobalResourceBundlePaths(commentCallbackHandler, variants);
    }

    @Override
    public boolean isGlobalResourceBundle(String resourceBundleId) {
        return this.rsHandler.isGlobalResourceBundle(resourceBundleId);
    }

    @Override
    public boolean containsValidBundleHashcode(String requestedPath) {
        return this.rsHandler.containsValidBundleHashcode(requestedPath);
    }

    @Override
    public String getBundleTextDirPath() {
        return this.rsHandler.getBundleTextDirPath();
    }
}

