/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.handler;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.GZIPOutputStream;
import net.jawr.web.DebugMode;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.ImageResourcesHandler;
import net.jawr.web.resource.bundle.CompositeResourceBundle;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleContent;
import net.jawr.web.resource.bundle.JoinableResourceBundlePropertySerializer;
import net.jawr.web.resource.bundle.factory.global.postprocessor.GlobalPostProcessingContext;
import net.jawr.web.resource.bundle.factory.global.preprocessor.GlobalPreprocessingContext;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.global.processor.AbstractGlobalProcessingContext;
import net.jawr.web.resource.bundle.global.processor.GlobalProcessor;
import net.jawr.web.resource.bundle.handler.ClientSideHandlerGenerator;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.hashcode.BundleHashcodeGenerator;
import net.jawr.web.resource.bundle.iterator.AbstractPathsIterator;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.iterator.ConditionalCommentCallbackHandler;
import net.jawr.web.resource.bundle.iterator.DebugModePathsIteratorImpl;
import net.jawr.web.resource.bundle.iterator.IECssDebugPathsIteratorImpl;
import net.jawr.web.resource.bundle.iterator.PathsIteratorImpl;
import net.jawr.web.resource.bundle.iterator.ResourceBundlePathsIterator;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.sorting.GlobalResourceBundleComparator;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;
import net.jawr.web.util.bom.UnicodeBOMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundlesHandlerImpl
implements ResourceBundlesHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundlesHandler.class);
    private List<JoinableResourceBundle> bundles;
    private List<JoinableResourceBundle> globalBundles;
    private List<JoinableResourceBundle> contextBundles;
    private List<String> liveProcessBundles = new ArrayList<String>();
    private ResourceReaderHandler resourceHandler;
    private ResourceBundleHandler resourceBundleHandler;
    private JawrConfig config;
    private ResourceBundlePostProcessor postProcessor;
    private ResourceBundlePostProcessor unitaryPostProcessor;
    private ResourceBundlePostProcessor compositePostProcessor;
    private ResourceBundlePostProcessor unitaryCompositePostProcessor;
    private GlobalProcessor<GlobalPreprocessingContext> resourceTypePreprocessor;
    private GlobalProcessor<GlobalPostProcessingContext> resourceTypePostprocessor;
    private ClientSideHandlerGenerator clientSideHandlerGenerator;
    private BundleHashcodeGenerator bundleHashcodeGenerator;
    private Properties bundleMapping;

    public ResourceBundlesHandlerImpl(List<JoinableResourceBundle> bundles, ResourceReaderHandler resourceHandler, ResourceBundleHandler resourceBundleHandler, JawrConfig config) {
        this(bundles, resourceHandler, resourceBundleHandler, config, null, null, null, null, null, null);
    }

    public ResourceBundlesHandlerImpl(List<JoinableResourceBundle> bundles, ResourceReaderHandler resourceHandler, ResourceBundleHandler resourceBundleHandler, JawrConfig config, ResourceBundlePostProcessor postProcessor, ResourceBundlePostProcessor unitaryPostProcessor, ResourceBundlePostProcessor compositePostProcessor, ResourceBundlePostProcessor unitaryCompositePostProcessor, GlobalProcessor<GlobalPreprocessingContext> resourceTypePreprocessor, GlobalProcessor<GlobalPostProcessingContext> resourceTypePostprocessor) {
        this.resourceHandler = resourceHandler;
        this.resourceBundleHandler = resourceBundleHandler;
        this.config = config;
        this.bundleHashcodeGenerator = config.getBundleHashcodeGenerator();
        this.postProcessor = postProcessor;
        this.unitaryPostProcessor = unitaryPostProcessor;
        this.compositePostProcessor = compositePostProcessor;
        this.unitaryCompositePostProcessor = unitaryCompositePostProcessor;
        this.resourceTypePreprocessor = resourceTypePreprocessor;
        this.resourceTypePostprocessor = resourceTypePostprocessor;
        this.bundles = new CopyOnWriteArrayList<JoinableResourceBundle>();
        this.bundles.addAll(bundles);
        this.splitBundlesByType(bundles);
        this.clientSideHandlerGenerator = (ClientSideHandlerGenerator)ClassLoaderResourceUtils.buildObjectInstance(config.getClientSideHandlerGeneratorClass());
        this.clientSideHandlerGenerator.init(config, this.globalBundles, this.contextBundles);
    }

    @Override
    public String getResourceType() {
        return this.resourceBundleHandler.getResourceType();
    }

    @Override
    public List<JoinableResourceBundle> getContextBundles() {
        return this.contextBundles;
    }

    @Override
    public List<JoinableResourceBundle> getGlobalBundles() {
        return this.globalBundles;
    }

    private void splitBundlesByType(List<JoinableResourceBundle> bundles) {
        ArrayList<JoinableResourceBundle> tmpGlobal = new ArrayList<JoinableResourceBundle>();
        ArrayList<JoinableResourceBundle> tmpContext = new ArrayList<JoinableResourceBundle>();
        for (JoinableResourceBundle bundle : bundles) {
            if (bundle.getInclusionPattern().isGlobal()) {
                tmpGlobal.add(bundle);
                continue;
            }
            tmpContext.add(bundle);
        }
        Collections.sort(tmpGlobal, new GlobalResourceBundleComparator());
        this.globalBundles = new CopyOnWriteArrayList<JoinableResourceBundle>();
        this.globalBundles.addAll(tmpGlobal);
        this.contextBundles = new CopyOnWriteArrayList<JoinableResourceBundle>();
        this.contextBundles.addAll(tmpContext);
    }

    @Override
    public boolean isGlobalResourceBundle(String resourceBundleId) {
        boolean isGlobalResourceBundle = false;
        for (JoinableResourceBundle bundle : this.globalBundles) {
            if (!bundle.getId().equals(resourceBundleId)) continue;
            isGlobalResourceBundle = true;
        }
        return isGlobalResourceBundle;
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(DebugMode debugMode, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.getBundleIterator(debugMode, this.globalBundles, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.getBundleIterator(this.getDebugMode(), this.globalBundles, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        ArrayList<JoinableResourceBundle> bundles = new ArrayList<JoinableResourceBundle>();
        for (JoinableResourceBundle bundle : this.globalBundles) {
            if (!bundle.getId().equals(bundleId)) continue;
            bundles.add(bundle);
            break;
        }
        return this.getBundleIterator(this.getDebugMode(), bundles, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getBundlePaths(String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.getBundlePaths(this.getDebugMode(), bundleId, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getBundlePaths(DebugMode debugMode, String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        ArrayList<JoinableResourceBundle> bundles = new ArrayList<JoinableResourceBundle>();
        if (!this.isGlobalResourceBundle(bundleId)) {
            for (JoinableResourceBundle bundle : this.contextBundles) {
                if (!bundle.getId().equals(bundleId)) continue;
                bundles.add(bundle);
                break;
            }
        }
        return this.getBundleIterator(debugMode, bundles, commentCallbackHandler, variants);
    }

    private ResourceBundlePathsIterator getBundleIterator(DebugMode debugMode, List<JoinableResourceBundle> bundles, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        AbstractPathsIterator bundlesIterator = debugMode.equals((Object)DebugMode.DEBUG) ? new DebugModePathsIteratorImpl(bundles, commentCallbackHandler, variants) : (debugMode.equals((Object)DebugMode.FORCE_NON_DEBUG_IN_IE) ? new IECssDebugPathsIteratorImpl(bundles, commentCallbackHandler, variants) : new PathsIteratorImpl(bundles, commentCallbackHandler, variants));
        return bundlesIterator;
    }

    @Override
    public void writeBundleTo(String bundlePath, Writer writer) throws ResourceNotFoundException {
        Reader rd = null;
        try {
            if (this.config.isDebugModeOn()) {
                rd = this.resourceHandler.getResource(bundlePath);
            } else {
                String path = PathNormalizer.removeVariantPrefixFromPath(bundlePath);
                rd = this.resourceBundleHandler.getResourceBundleReader(path);
                if (this.liveProcessBundles.contains(path)) {
                    rd = this.processInLive(rd);
                }
            }
            IOUtils.copy(rd, writer);
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new BundlingProcessException("Unexpected IOException writing bundle[" + bundlePath + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(rd);
                throw throwable;
            }
        }
        IOUtils.close(rd);
    }

    private StringReader processInLive(Reader reader) throws IOException {
        String requestURL = ThreadLocalJawrContext.getRequestURL();
        StringWriter swriter = new StringWriter();
        IOUtils.copy(reader, swriter, true);
        String updatedContent = swriter.getBuffer().toString();
        if (requestURL != null) {
            updatedContent = updatedContent.replaceAll("\\{JAWR_BUNDLE_PATH\\}", requestURL);
        }
        return new StringReader(updatedContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamBundleTo(String bundlePath, OutputStream out) throws ResourceNotFoundException {
        String path = PathNormalizer.removeVariantPrefixFromPath(bundlePath);
        ReadableByteChannel data = null;
        try {
            block7: {
                block6: {
                    if (!this.liveProcessBundles.contains(path)) break block6;
                    Reader rd = null;
                    try {
                        rd = this.resourceBundleHandler.getResourceBundleReader(path);
                        StringReader strRd = this.processInLive(rd);
                        StringWriter strWriter = new StringWriter();
                        IOUtils.copy(strRd, (Writer)strWriter);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        GZIPOutputStream gzOut = new GZIPOutputStream(bos);
                        byte[] byteData = strWriter.getBuffer().toString().getBytes(this.config.getResourceCharset().name());
                        gzOut.write(byteData, 0, byteData.length);
                        gzOut.close();
                        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                        data = Channels.newChannel(bis);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(rd);
                        throw throwable;
                    }
                    IOUtils.close(rd);
                    break block7;
                }
                data = this.resourceBundleHandler.getResourceBundleChannel(path);
            }
            WritableByteChannel outChannel = Channels.newChannel(out);
            IOUtils.copy(data, outChannel);
        }
        catch (IOException e) {
            try {
                throw new BundlingProcessException("Unexpected IOException writing bundle [" + path + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(data);
                throw throwable;
            }
        }
        IOUtils.close(data);
    }

    @Override
    public JawrConfig getConfig() {
        return this.config;
    }

    private DebugMode getDebugMode() {
        return this.config.isDebugModeOn() ? DebugMode.DEBUG : DebugMode.NO_DEBUG;
    }

    @Override
    public void initAllBundles() {
        AbstractGlobalProcessingContext ctx;
        boolean processBundleFlag;
        if (this.config.getUseBundleMapping()) {
            this.bundleMapping = this.resourceBundleHandler.getJawrBundleMapping();
        }
        boolean mappingFileExists = this.resourceBundleHandler.isExistingMappingFile();
        boolean bl = processBundleFlag = !this.config.getUseBundleMapping() || !mappingFileExists;
        if (this.resourceTypePreprocessor != null) {
            ctx = new GlobalPreprocessingContext(this.config, this.resourceHandler, processBundleFlag);
            this.resourceTypePreprocessor.processBundles((GlobalPreprocessingContext)ctx, this.bundles);
        }
        for (JoinableResourceBundle bundle : this.bundles) {
            boolean processBundle = processBundleFlag;
            if (!ThreadLocalJawrContext.isBundleProcessingAtBuildTime() && null != bundle.getAlternateProductionURL()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No bundle generated for '" + bundle.getId() + "' because a production URL is defined for this bundle.");
                }
                processBundle = false;
            }
            if (bundle instanceof CompositeResourceBundle) {
                this.joinAndStoreCompositeResourcebundle((CompositeResourceBundle)bundle, processBundle);
            } else {
                this.joinAndStoreBundle(bundle, processBundle);
            }
            if (!this.config.getUseBundleMapping() || mappingFileExists) continue;
            JoinableResourceBundlePropertySerializer.serializeInProperties(bundle, this.resourceBundleHandler.getResourceType(), this.bundleMapping);
        }
        if (this.resourceTypePostprocessor != null) {
            ctx = new GlobalPostProcessingContext(this.config, this, this.resourceHandler, processBundleFlag);
            this.resourceTypePostprocessor.processBundles((GlobalPostProcessingContext)ctx, this.bundles);
        }
        if (this.config.getUseBundleMapping() && !mappingFileExists) {
            ImageResourcesHandler imgRsHandler;
            this.resourceBundleHandler.storeJawrBundleMapping(this.bundleMapping);
            if (this.resourceBundleHandler.getResourceType().equals("css") && (imgRsHandler = (ImageResourcesHandler)this.config.getContext().getAttribute("net.jawr.web.resource.bundle.IMG_CONTEXT_ATTRIBUTE")) != null) {
                JawrConfig imgJawrConfig = imgRsHandler.getConfig();
                String jawrWorkingDirectory = imgJawrConfig.getJawrWorkingDirectory();
                if (imgJawrConfig.getUseBundleMapping() && (jawrWorkingDirectory == null || !jawrWorkingDirectory.startsWith("/"))) {
                    Properties props = new Properties();
                    props.putAll(imgRsHandler.getImageMap());
                    imgRsHandler.getRsBundleHandler().storeJawrBundleMapping(props);
                }
            }
        }
    }

    private void joinAndStoreCompositeResourcebundle(CompositeResourceBundle composite, boolean processBundle) {
        BundleProcessingStatus status = new BundleProcessingStatus("file", composite, this.resourceHandler, this.config);
        Map<String, VariantSet> compositeBundleVariants = new HashMap<String, VariantSet>();
        for (JoinableResourceBundle childbundle : composite.getChildBundles()) {
            if (null == childbundle.getVariants()) continue;
            compositeBundleVariants = VariantUtils.concatVariants(compositeBundleVariants, childbundle.getVariants());
        }
        composite.setVariants(compositeBundleVariants);
        status.setSearchingPostProcessorVariants(true);
        this.joinAndPostProcessBundle(composite, status, processBundle);
        Map<String, VariantSet> postProcessVariants = status.getPostProcessVariants();
        if (!postProcessVariants.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Post process variants found for bundle " + composite.getId() + ":" + postProcessVariants);
            }
            Map<String, VariantSet> newVariants = VariantUtils.concatVariants(composite.getVariants(), postProcessVariants);
            composite.setVariants(newVariants);
            status.setSearchingPostProcessorVariants(false);
            this.joinAndPostProcessBundle(composite, status, processBundle);
        }
    }

    private void joinAndPostProcessBundle(CompositeResourceBundle composite, BundleProcessingStatus status, boolean processBundle) {
        List<Map<String, String>> allVariants = VariantUtils.getAllVariants(composite.getVariants());
        allVariants.add(null);
        for (Map<String, String> variants : allVariants) {
            status.setBundleVariants(variants);
            JoinableResourceBundleContent store = new JoinableResourceBundleContent();
            for (JoinableResourceBundle childbundle : composite.getChildBundles()) {
                JoinableResourceBundleContent childContent = this.joinAndPostprocessBundle(childbundle, variants, status, processBundle);
                status.setProcessingType("file");
                StringBuffer content = this.executeUnitaryPostProcessing(composite, status, childContent.getContent(), this.unitaryCompositePostProcessor);
                childContent.setContent(content);
                store.append(childContent);
            }
            store = this.postProcessJoinedCompositeBundle(composite, store.getContent(), status);
            if (!processBundle) continue;
            String variantKey = VariantUtils.getVariantKey(variants);
            String name = VariantUtils.getVariantBundleName(composite.getId(), variantKey);
            this.storeBundle(name, store);
            this.initBundleDataHashcode(composite, store, variantKey);
        }
    }

    private JoinableResourceBundleContent postProcessJoinedCompositeBundle(CompositeResourceBundle composite, StringBuffer content, BundleProcessingStatus status) {
        JoinableResourceBundleContent store = new JoinableResourceBundleContent();
        StringBuffer processedContent = null;
        status.setProcessingType("bundle");
        ResourceBundlePostProcessor bundlePostProcessor = composite.getBundlePostProcessor();
        processedContent = null != bundlePostProcessor ? bundlePostProcessor.postProcessBundle(status, content) : (null != this.compositePostProcessor ? this.compositePostProcessor.postProcessBundle(status, content) : content);
        store.setContent(processedContent);
        return store;
    }

    private void initBundleDataHashcode(JoinableResourceBundle bundle, JoinableResourceBundleContent store, String variant) {
        String bundleHashcode = this.bundleHashcodeGenerator.generateHashCode(this.config, store.getContent().toString());
        bundle.setBundleDataHashCode(variant, bundleHashcode);
    }

    @Override
    public boolean containsValidBundleHashcode(String requestedPath) {
        boolean validHashcode = false;
        String[] pathInfos = PathNormalizer.extractBundleInfoFromPath(requestedPath);
        if (pathInfos != null) {
            String bundlePrefix = pathInfos[0];
            String bundleId = pathInfos[1];
            String variantKey = pathInfos[2];
            String hashcode = pathInfos[3];
            JoinableResourceBundle bundle = this.resolveBundleForPath(bundleId);
            if (bundle != null) {
                String bundleHashcode = bundle.getBundleDataHashCode(variantKey);
                if (hashcode == null && bundleHashcode == null || hashcode != null && hashcode.equals(bundleHashcode) && (bundlePrefix == null && bundle.getBundlePrefix() == null || bundlePrefix != null && bundlePrefix.equals(bundle.getBundlePrefix()))) {
                    validHashcode = true;
                }
            }
        }
        return validHashcode;
    }

    private void joinAndStoreBundle(JoinableResourceBundle bundle, boolean processBundle) {
        if (processBundle) {
            BundleProcessingStatus status = new BundleProcessingStatus("file", bundle, this.resourceHandler, this.config);
            JoinableResourceBundleContent store = null;
            status.setSearchingPostProcessorVariants(true);
            this.joinAndPostProcessBundle(bundle, status, processBundle);
            Map<String, VariantSet> postProcessVariants = status.getPostProcessVariants();
            if (!postProcessVariants.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Post process variants found for bundle " + bundle.getId() + ":" + postProcessVariants);
                }
                Map<String, VariantSet> newVariants = VariantUtils.concatVariants(bundle.getVariants(), postProcessVariants);
                bundle.setVariants(newVariants);
                status.setSearchingPostProcessorVariants(false);
                this.joinAndPostProcessBundle(bundle, status, processBundle);
            }
            store = this.joinAndPostprocessBundle(bundle, null, status, processBundle);
            this.storeBundle(bundle.getId(), store);
            this.initBundleDataHashcode(bundle, store, null);
        }
    }

    private void storeBundle(String bundleId, JoinableResourceBundleContent store) {
        if (this.bundleMustBeProcessedInLive(store.getContent().toString())) {
            this.liveProcessBundles.add(bundleId);
        }
        this.resourceBundleHandler.storeBundle(bundleId, store);
    }

    private boolean bundleMustBeProcessedInLive(String content) {
        return content.indexOf("{JAWR_BUNDLE_PATH}") != -1;
    }

    private void joinAndPostProcessBundle(JoinableResourceBundle bundle, BundleProcessingStatus status, boolean processBundle) {
        List<Map<String, String>> allVariants = VariantUtils.getAllVariants(bundle.getVariants());
        allVariants.add(null);
        for (Map<String, String> variantMap : allVariants) {
            status.setBundleVariants(variantMap);
            String variantKey = VariantUtils.getVariantKey(variantMap);
            String name = VariantUtils.getVariantBundleName(bundle.getId(), variantKey);
            JoinableResourceBundleContent store = this.joinAndPostprocessBundle(bundle, variantMap, status, processBundle);
            this.storeBundle(name, store);
            this.initBundleDataHashcode(bundle, store, variantKey);
        }
    }

    private JoinableResourceBundleContent joinAndPostprocessBundle(JoinableResourceBundle bundle, Map<String, String> variants, BundleProcessingStatus status, boolean processBundle) {
        JoinableResourceBundleContent bundleContent = new JoinableResourceBundleContent();
        StringBuffer bundleData = new StringBuffer();
        StringBuffer store = null;
        try {
            boolean firstPath = true;
            Iterator<BundlePath> pathIterator = null;
            pathIterator = bundle.getInclusionPattern().isIncludeOnlyOnDebug() ? bundle.getItemDebugPathList(variants).iterator() : bundle.getItemPathList(variants).iterator();
            Iterator<BundlePath> it = pathIterator;
            while (it.hasNext()) {
                StringWriter writer = new StringWriter();
                BufferedWriter bwriter = new BufferedWriter(writer);
                String path = it.next().getPath();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding file [" + path + "] to bundle " + bundle.getId());
                }
                Reader rd = null;
                try {
                    rd = this.resourceHandler.getResource(path, true);
                }
                catch (ResourceNotFoundException e) {
                    LOGGER.warn("A mapped resource was not found: [" + path + "]. Please check your configuration");
                    continue;
                }
                status.setLastPathAdded(path);
                rd = new UnicodeBOMReader(rd, this.config.getResourceCharset());
                if (!firstPath && ((UnicodeBOMReader)rd).hasBOM()) {
                    ((UnicodeBOMReader)rd).skipBOM();
                } else {
                    firstPath = false;
                }
                IOUtils.copy(rd, bwriter, true);
                StringBuffer buffer = writer.getBuffer();
                if (!buffer.toString().endsWith(StringUtils.LINE_SEPARATOR)) {
                    buffer.append(StringUtils.LINE_SEPARATOR);
                }
                status.setProcessingType("file");
                bundleData.append(this.executeUnitaryPostProcessing(bundle, status, buffer, this.unitaryPostProcessor));
            }
            store = this.executeBundlePostProcessing(bundle, status, bundleData);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException generating collected file [" + bundle.getId() + "].", e);
        }
        bundleContent.setContent(store);
        return bundleContent;
    }

    private StringBuffer executeUnitaryPostProcessing(JoinableResourceBundle bundle, BundleProcessingStatus status, StringBuffer content, ResourceBundlePostProcessor defaultPostProcessor) {
        StringBuffer bundleData = new StringBuffer();
        status.setProcessingType("file");
        if (null != bundle.getUnitaryPostProcessor()) {
            StringBuffer resourceData = bundle.getUnitaryPostProcessor().postProcessBundle(status, content);
            bundleData.append(resourceData);
        } else if (null != defaultPostProcessor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("POSTPROCESSING UNIT:" + status.getLastPathAdded());
            }
            StringBuffer resourceData = defaultPostProcessor.postProcessBundle(status, content);
            bundleData.append(resourceData);
        } else {
            bundleData = content;
        }
        return bundleData;
    }

    private StringBuffer executeBundlePostProcessing(JoinableResourceBundle bundle, BundleProcessingStatus status, StringBuffer bundleData) {
        status.setProcessingType("bundle");
        status.setLastPathAdded(bundle.getId());
        StringBuffer store = null != bundle.getBundlePostProcessor() ? bundle.getBundlePostProcessor().postProcessBundle(status, bundleData) : (null != this.postProcessor ? this.postProcessor.postProcessBundle(status, bundleData) : bundleData);
        return store;
    }

    @Override
    public JoinableResourceBundle resolveBundleForPath(String path) {
        JoinableResourceBundle theBundle = null;
        for (JoinableResourceBundle bundle : this.bundles) {
            if (!bundle.getId().equals(path) && !bundle.belongsToBundle(path)) continue;
            theBundle = bundle;
            break;
        }
        return theBundle;
    }

    @Override
    public ClientSideHandlerGenerator getClientSideHandler() {
        return this.clientSideHandlerGenerator;
    }

    @Override
    public String getBundleTextDirPath() {
        return this.resourceBundleHandler.getBundleTextDirPath();
    }
}

