/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.IOException;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSCombineMediaPostProcessor
extends AbstractChainedResourceBundlePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSCombineMediaPostProcessor.class);
    protected static final String CSS_MEDIA_RULE = "@media";
    protected static final String CSS_MEDIA_RULE_OPEN = "{";
    protected static final String CSS_MEDIA_RULE_CLOSE = "}";

    public CSSCombineMediaPostProcessor() {
        super("cssCombineMedia");
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        LOGGER.info("Post processing file '" + status.getLastPathAdded() + "'");
        String bundleMediaTypePropertyName = "jawr.css.bundle." + status.getCurrentBundle().getName() + ".media";
        String bundleMediaType = status.getJawrConfig().getProperty(bundleMediaTypePropertyName);
        if (bundleMediaType == null) {
            LOGGER.warn("no bundle media type provided; use 'screen'");
            bundleMediaType = "screen";
        }
        LOGGER.info("bundle media type: " + bundleMediaType);
        StringBuffer sb = new StringBuffer("@media " + bundleMediaType + " " + CSS_MEDIA_RULE_OPEN + StringUtils.LINE_SEPARATOR);
        sb.append(bundleData);
        sb.append(CSS_MEDIA_RULE_CLOSE + StringUtils.LINE_SEPARATOR + StringUtils.LINE_SEPARATOR);
        LOGGER.info("Postprocessing finished");
        return sb;
    }
}

