/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.ImageResourcesHandler;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.css.CssImageUrlRewriter;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.util.StringUtils;

public class CSSImportPostProcessor
extends AbstractChainedResourceBundlePostProcessor {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("@import\\s*url\\(\\s*[\"']?([^\"']*)[\"']?\\s*\\)\\s*(\\w+)?\\s*;?", 2);

    public CSSImportPostProcessor() {
        super("cssimport");
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        String data = bundleData.toString();
        Matcher matcher = IMPORT_PATTERN.matcher(data);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String content = this.getCssPathContent(matcher.group(1), matcher.group(2), status);
            matcher.appendReplacement(sb, RegexUtil.adaptReplacementToMatcher(content));
        }
        matcher.appendTail(sb);
        return sb;
    }

    private String getCssPathContent(String cssPathToImport, String media, BundleProcessingStatus status) throws IOException {
        String currentCssPath = status.getLastPathAdded();
        String path = cssPathToImport;
        JawrConfig jawrConfig = status.getJawrConfig();
        if (!cssPathToImport.startsWith("/") && !jawrConfig.getGeneratorRegistry().isPathGenerated(path)) {
            path = PathNormalizer.concatWebPath(currentCssPath, cssPathToImport);
        }
        Reader reader = null;
        try {
            reader = status.getRsReader().getResource(path, true);
        }
        catch (ResourceNotFoundException e) {
            throw new IOException("Css to import '" + path + "' was not found");
        }
        StringWriter content = new StringWriter();
        IOUtils.copy(reader, content, true);
        ImageResourcesHandler imgRsHandler = (ImageResourcesHandler)jawrConfig.getContext().getAttribute("net.jawr.web.resource.bundle.IMG_CONTEXT_ATTRIBUTE");
        if (imgRsHandler != null) {
            jawrConfig = imgRsHandler.getConfig();
        }
        CssImportedUrlRewriter urlRewriter = new CssImportedUrlRewriter(jawrConfig);
        StringBuffer result = new StringBuffer();
        boolean isMediaAttributeSet = StringUtils.isNotEmpty(media);
        if (isMediaAttributeSet) {
            result.append("@media " + media + " {\n");
        }
        result.append(urlRewriter.rewriteUrl(path, currentCssPath, content.getBuffer().toString()));
        if (isMediaAttributeSet) {
            result.append("\n}\n");
        }
        return result.toString();
    }

    private static class CssImportedUrlRewriter
    extends CssImageUrlRewriter {
        private GeneratorRegistry generatorRegistry;

        public CssImportedUrlRewriter(JawrConfig jawrConfig) {
            super(jawrConfig);
            this.generatorRegistry = jawrConfig.getGeneratorRegistry();
        }

        @Override
        protected String getRewrittenImagePath(String originalCssPath, String newCssPath, String url) throws IOException {
            String currentPath = originalCssPath;
            String imgPath = PathNormalizer.concatWebPath(currentPath, url);
            if (!this.generatorRegistry.isGeneratedImage(imgPath) && !this.generatorRegistry.isHandlingCssImage(originalCssPath)) {
                imgPath = PathNormalizer.getRelativeWebPath(PathNormalizer.getParentPath(newCssPath), imgPath);
            }
            return imgPath;
        }
    }
}

