/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensesIncluderPostProcessor
extends AbstractChainedResourceBundlePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicensesIncluderPostProcessor.class);

    public LicensesIncluderPostProcessor() {
        super("license");
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        JoinableResourceBundle bundle = status.getCurrentBundle();
        Charset charset = status.getJawrConfig().getResourceCharset();
        if (bundle.getLicensesPathList().size() == 0) {
            return bundleData;
        }
        ByteArrayOutputStream baOs = new ByteArrayOutputStream();
        WritableByteChannel wrChannel = Channels.newChannel(baOs);
        Writer writer = Channels.newWriter(wrChannel, charset.name());
        BufferedWriter bwriter = new BufferedWriter(writer);
        Iterator<String> it = bundle.getLicensesPathList().iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding license file: " + path);
            }
            Reader rd = null;
            try {
                rd = status.getRsReader().getResource(path);
            }
            catch (ResourceNotFoundException e) {
                throw new BundlingProcessException("Unexpected ResourceNotFoundException when reading a sorting file [" + path + "]");
            }
            BufferedReader bRd = new BufferedReader(rd);
            String line = bRd.readLine();
            while (line != null) {
                bwriter.write(line);
                line = bRd.readLine();
                if (line == null && !it.hasNext()) continue;
                bwriter.newLine();
            }
            bRd.close();
        }
        bwriter.close();
        return new StringBuffer(baOs.toString(charset.name())).append(bundleData);
    }
}

