/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.IOException;
import java.util.HashMap;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.ImageResourcesHandler;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.css.CssImageUrlRewriter;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.servlet.util.ImageMIMETypesSupport;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessorCssImageUrlRewriter
extends CssImageUrlRewriter {
    private static Logger LOGGER = LoggerFactory.getLogger(PostProcessorCssImageUrlRewriter.class);
    protected BundleProcessingStatus status;

    public PostProcessorCssImageUrlRewriter(BundleProcessingStatus status) {
        super(status.getJawrConfig());
        this.status = status;
    }

    @Override
    protected String getRewrittenImagePath(String originalCssPath, String newCssPath, String url) throws IOException {
        JawrConfig jawrConfig = this.status.getJawrConfig();
        ImageResourcesHandler imgRsHandler = (ImageResourcesHandler)jawrConfig.getContext().getAttribute("net.jawr.web.resource.bundle.IMG_CONTEXT_ATTRIBUTE");
        String imgServletPath = "";
        if (imgRsHandler != null) {
            imgServletPath = PathNormalizer.asPath(imgRsHandler.getConfig().getServletMapping());
        }
        String imgUrl = null;
        String currentCss = originalCssPath;
        boolean generatedImg = false;
        if (imgRsHandler != null) {
            GeneratorRegistry imgRsGeneratorRegistry = imgRsHandler.getConfig().getGeneratorRegistry();
            generatedImg = imgRsGeneratorRegistry.isGeneratedImage(url);
        }
        boolean cssGeneratorIsHandleCssImage = this.isCssGeneratorHandlingCssImage(currentCss, this.status);
        String rootPath = currentCss;
        if (generatedImg || cssGeneratorIsHandleCssImage) {
            String tempUrl = url;
            if (cssGeneratorIsHandleCssImage && !generatedImg) {
                tempUrl = PathNormalizer.concatWebPath(rootPath, url);
            }
            imgUrl = this.rewriteURL(this.status, tempUrl, imgServletPath, newCssPath, imgRsHandler);
        } else {
            if (jawrConfig.getGeneratorRegistry().isPathGenerated(rootPath)) {
                rootPath = rootPath.substring(rootPath.indexOf(":") + 1);
            }
            imgUrl = PathNormalizer.concatWebPath(rootPath, url);
            imgUrl = this.rewriteURL(this.status, imgUrl, imgServletPath, newCssPath, imgRsHandler);
        }
        if (imgUrl == null) {
            LOGGER.error("The CSS image path for '" + url + "' defined in '" + currentCss + "' is out of the application context. Please check your CSS file.");
        }
        return imgUrl;
    }

    private boolean isCssGeneratorHandlingCssImage(String currentCss, BundleProcessingStatus status) {
        return status.getJawrConfig().getGeneratorRegistry().isHandlingCssImage(currentCss);
    }

    protected String rewriteURL(BundleProcessingStatus status, String url, String imgServletPath, String newCssPath, ImageResourcesHandler imgRsHandler) throws IOException {
        String imgUrl = url;
        if (this.isImageResource(imgUrl)) {
            imgUrl = this.addCacheBuster(status, url, imgRsHandler);
            if (StringUtils.isNotEmpty(imgServletPath)) {
                imgUrl = imgServletPath + "/" + imgUrl;
            }
        }
        imgUrl = PathNormalizer.asPath(imgUrl);
        return PathNormalizer.getRelativeWebPath(PathNormalizer.getParentPath(newCssPath), imgUrl);
    }

    protected boolean isImageResource(String resourcePath) {
        String extension = FileNameUtils.getExtension(resourcePath);
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        return ImageMIMETypesSupport.getSupportedProperties(this).containsKey(extension);
    }

    private String addCacheBuster(BundleProcessingStatus status, String url, ImageResourcesHandler imgRsHandler) throws IOException {
        HashMap<String, String> imageMapping = (HashMap<String, String>)status.getData("jawrImageMapping");
        String newUrl = null;
        if (imageMapping != null && (newUrl = (String)imageMapping.get(url)) != null) {
            return newUrl;
        }
        if (imgRsHandler != null) {
            newUrl = imgRsHandler.getCacheUrl(url);
            if (newUrl != null) {
                return newUrl;
            }
            try {
                newUrl = CheckSumUtils.getCacheBustedUrl(url, imgRsHandler.getRsReaderHandler(), imgRsHandler.getConfig());
            }
            catch (ResourceNotFoundException e) {
                LOGGER.info("Impossible to define the checksum for the resource '" + url + "'. ");
                return url;
            }
            catch (IOException e) {
                LOGGER.info("Impossible to define the checksum for the resource '" + url + "'.");
                return url;
            }
            imgRsHandler.addMapping(url, newUrl);
        } else {
            newUrl = url;
        }
        if (imageMapping == null) {
            imageMapping = new HashMap<String, String>();
            status.putData("jawrImageMapping", imageMapping);
        }
        imageMapping.put(url, newUrl);
        return newUrl;
    }
}

