/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl.css.base64;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.ImageResourcesHandler;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.impl.PostProcessorCssImageUrlRewriter;
import net.jawr.web.resource.bundle.postprocess.impl.css.base64.Base64EncodedResource;
import net.jawr.web.servlet.util.ImageMIMETypesSupport;
import net.jawr.web.util.Base64Encoder;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64PostProcessorCssImageUrlRewriter
extends PostProcessorCssImageUrlRewriter {
    private Logger LOGGER = LoggerFactory.getLogger(Base64PostProcessorCssImageUrlRewriter.class);
    private static final String DATA_PREFIX = "data:";
    private static final String MHTML_PREFIX = "mhtml:";
    private static final Pattern ANNOTATION_BASE64_PATTERN = Pattern.compile("jawr(?:\\s)*:(?:\\s)*(base64)(-skip)?");
    private static final Pattern ANNOTATION_SPRITE_PATTERN = Pattern.compile("sprite(?:\\s)*:(?:\\s)*?");
    private static final int ANNOTATION_GROUP = 9;
    private static final Pattern URL_WITH_ANNOTATION_PATTERN = Pattern.compile("((" + URL_REGEXP + "\\s*)+)" + "([^;]*);?" + "\\s*(/\\*\\*(?:.|[\\n\\r])*?\\*/)?", 2);
    private static final int MAX_LENGTH_FILE = 30000;
    private int maxFileSize;
    private Map<String, Base64EncodedResource> encodedResources = null;
    private boolean encodeByDefault;
    private boolean encodeSprite;
    private boolean skipBase64Encoding;

    public Base64PostProcessorCssImageUrlRewriter(BundleProcessingStatus status) {
        super(status);
        this.encodedResources = (Map)status.getData("BASE64_ENCODED_RESOURCES");
        this.maxFileSize = 30000;
        Properties configProperties = status.getJawrConfig().getConfigProperties();
        String maxLengthProperty = (String)configProperties.get("jawr.css.postprocessor.base64ImageEncoder.maxFileLength");
        if (StringUtils.isNotEmpty(maxLengthProperty)) {
            this.maxFileSize = Integer.parseInt(maxLengthProperty);
        }
        String strEncodeByDefault = (String)configProperties.get("jawr.css.postprocessor.base64ImageEncoder.encode.by.default");
        this.encodeByDefault = this.getBooleanValue(strEncodeByDefault, true);
        String strEncodeSprite = (String)configProperties.get("jawr.css.postprocessor.base64ImageEncoder.encode.sprite");
        this.encodeSprite = this.getBooleanValue(strEncodeSprite, false);
        this.LOGGER.debug("max file length: " + this.maxFileSize);
    }

    private boolean getBooleanValue(String strVal, boolean defaultValue) {
        boolean result = defaultValue;
        if (strVal != null) {
            result = Boolean.valueOf(strVal);
        }
        return result;
    }

    @Override
    public StringBuffer rewriteUrl(String originalCssPath, String newCssPath, String originalCssContent) throws IOException {
        Matcher matcher = URL_WITH_ANNOTATION_PATTERN.matcher(originalCssContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String annotation = matcher.group(9);
            if (StringUtils.isNotEmpty(annotation)) {
                Matcher annotationMatcher = ANNOTATION_BASE64_PATTERN.matcher(annotation);
                if (annotationMatcher.find()) {
                    this.skipBase64Encoding = annotationMatcher.group(2) != null;
                } else {
                    annotationMatcher = ANNOTATION_SPRITE_PATTERN.matcher(annotation);
                    if (annotationMatcher.find()) {
                        this.skipBase64Encoding = !this.encodeSprite;
                    }
                }
            } else {
                this.skipBase64Encoding = !this.encodeByDefault;
            }
            StringBuffer sbUrl = new StringBuffer();
            Matcher urlMatcher = URL_PATTERN.matcher(matcher.group());
            while (urlMatcher.find()) {
                String url = urlMatcher.group();
                if (!this.encodeSprite && url.indexOf("sprite:") != -1) {
                    this.skipBase64Encoding = true;
                }
                if (this.LOGGER.isDebugEnabled() && this.skipBase64Encoding) {
                    this.LOGGER.debug("Skip encoding image resource : " + url);
                }
                url = this.getUrlPath(url, originalCssPath, newCssPath);
                urlMatcher.appendReplacement(sbUrl, RegexUtil.adaptReplacementToMatcher(url));
            }
            urlMatcher.appendTail(sbUrl);
            matcher.appendReplacement(sb, RegexUtil.adaptReplacementToMatcher(sbUrl.toString()));
        }
        matcher.appendTail(sb);
        return sb;
    }

    @Override
    protected String rewriteURL(BundleProcessingStatus status, String url, String imgServletPath, String newCssPath, ImageResourcesHandler imgRsHandler) throws IOException {
        String imgUrl = url;
        String browser = status.getVariant("browser");
        if (this.skipBase64Encoding) {
            imgUrl = super.rewriteURL(status, imgUrl, imgServletPath, newCssPath, imgRsHandler);
        } else {
            this.LOGGER.info("Encoding resource: " + url);
            try {
                InputStream is = imgRsHandler.getRsReaderHandler().getResourceAsStream(url);
                String fileExtension = FileNameUtils.getExtension(url);
                String fileMimeType = (String)ImageMIMETypesSupport.getSupportedProperties(this).get(fileExtension);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy(is, out, true);
                int size = out.size();
                if (size > this.maxFileSize) {
                    this.LOGGER.warn("File content length of '" + url + "' exceeds maximum file length: " + size + " > " + this.maxFileSize);
                } else {
                    byte[] data = out.toByteArray();
                    StringBuffer s = new StringBuffer(this.encodeInBase64(data));
                    Base64EncodedResource encodedImage = new Base64EncodedResource();
                    encodedImage.setId(url.hashCode());
                    encodedImage.setType(fileMimeType);
                    encodedImage.setBase64Encoding(s);
                    this.encodedResources.put(encodedImage.getId(), encodedImage);
                    imgUrl = "ie6".equals(browser) || "ie7".equals(browser) ? "mhtml:{JAWR_BUNDLE_PATH}!" + encodedImage.getId() : DATA_PREFIX + fileMimeType + ";base64," + s;
                }
            }
            catch (IOException e) {
                this.LOGGER.error("Unable to rewrite image URL", (Throwable)e);
            }
            catch (ResourceNotFoundException e) {
                this.LOGGER.error("The resource '" + e.getRequestedPath() + "' has not been found.");
            }
            catch (Throwable e) {
                this.LOGGER.error("Unable to rewrite image URL", e);
            }
        }
        return imgUrl;
    }

    private String encodeInBase64(byte[] data) {
        return new String(Base64Encoder.encode(data));
    }
}

