/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.jawr.web.DebugMode;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.iterator.ConditionalCommentCallbackHandler;
import net.jawr.web.resource.bundle.iterator.ResourceBundlePathsIterator;
import net.jawr.web.resource.bundle.renderer.BundleRenderer;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import net.jawr.web.resource.bundle.renderer.ConditionalCommentRenderer;
import net.jawr.web.servlet.RendererRequestUtils;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBundleLinkRenderer
implements BundleRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBundleLinkRenderer.class);
    private static final long serialVersionUID = 7440895269616865487L;
    protected ResourceBundlesHandler bundler;
    private boolean useRandomParam;

    public void init(ResourceBundlesHandler bundler, Boolean useRandomParam) {
        this.bundler = bundler;
        this.useRandomParam = useRandomParam == null ? bundler.getConfig().isDebugUseRandomParam() : useRandomParam.booleanValue();
    }

    @Override
    public ResourceBundlesHandler getBundler() {
        return this.bundler;
    }

    @Override
    public void renderBundleLinks(String requestedPath, BundleRendererContext ctx, Writer out) throws IOException {
        boolean debugOn = this.bundler.getConfig().isDebugModeOn();
        JoinableResourceBundle bundle = this.bundler.resolveBundleForPath(requestedPath);
        if (null == bundle) {
            LOGGER.warn("No bundle found for path : " + requestedPath);
            return;
        }
        if (!ctx.isGlobalBundleAdded()) {
            this.renderGlobalBundleLinks(ctx, out, debugOn);
        }
        this.renderBundleLinks(bundle, requestedPath, ctx, out, debugOn, true);
        if (debugOn) {
            this.addComment("Finished adding members resolved by " + requestedPath, out);
        }
    }

    protected void renderBundleLinks(JoinableResourceBundle bundle, String requestedPath, BundleRendererContext ctx, Writer out, boolean debugOn, boolean renderDependencyLinks) throws IOException {
        if (debugOn) {
            this.addComment("Start adding members resolved by '" + requestedPath + "'. Bundle id is: '" + bundle.getId() + "'", out);
        }
        if (ctx.getIncludedBundles().add(bundle.getId())) {
            if (renderDependencyLinks) {
                this.renderBundleDependenciesLinks(requestedPath, ctx, out, debugOn, bundle.getDependencies());
            }
            this.renderBundleLinks(bundle, ctx, ctx.getVariants(), out, debugOn);
        } else if (debugOn) {
            this.addComment("The bundle '" + bundle.getId() + "' is already included in the page.", out);
        }
    }

    protected void renderBundleLinks(JoinableResourceBundle bundle, BundleRendererContext ctx, Map<String, String> variant, Writer out, boolean debugOn) throws IOException {
        ResourceBundlePathsIterator it = this.bundler.getBundlePaths(bundle.getId(), new ConditionalCommentRenderer(out), variant);
        this.renderBundleLinks(it, ctx, debugOn, out);
    }

    protected void renderGlobalBundleLinks(BundleRendererContext ctx, Writer out, boolean debugOn) throws IOException {
        if (debugOn) {
            this.addComment("Start adding global members.", out);
        }
        this.performGlobalBundleLinksRendering(ctx, out, debugOn);
        ctx.setGlobalBundleAdded(true);
        if (debugOn) {
            this.addComment("Finished adding global members.", out);
        }
    }

    protected void performGlobalBundleLinksRendering(BundleRendererContext ctx, Writer out, boolean debugOn) throws IOException {
        ResourceBundlePathsIterator resourceBundleIterator = this.bundler.getGlobalResourceBundlePaths(this.getDebugMode(debugOn), (ConditionalCommentCallbackHandler)new ConditionalCommentRenderer(out), ctx.getVariants());
        this.renderBundleLinks(resourceBundleIterator, ctx, debugOn, out);
    }

    protected DebugMode getDebugMode(boolean debugOn) {
        return debugOn ? DebugMode.DEBUG : DebugMode.NO_DEBUG;
    }

    private void renderBundleDependenciesLinks(String requestedPath, BundleRendererContext ctx, Writer out, boolean debugOn, List<JoinableResourceBundle> dependencies) throws IOException {
        if (dependencies != null && !dependencies.isEmpty()) {
            for (JoinableResourceBundle dependencyBundle : dependencies) {
                if (debugOn) {
                    this.addComment("Start adding dependency '" + dependencyBundle.getId() + "'", out);
                }
                this.renderBundleLinks(dependencyBundle, requestedPath, ctx, out, debugOn, false);
                if (!debugOn) continue;
                this.addComment("Finished adding dependency '" + dependencyBundle.getId() + "'", out);
            }
        }
    }

    protected void renderBundleLinks(ResourceBundlePathsIterator it, BundleRendererContext ctx, boolean debugOn, Writer out) throws IOException {
        String contextPath = ctx.getContextPath();
        boolean useGzip = ctx.isUseGzip();
        boolean isSslRequest = ctx.isSslRequest();
        Random randomSeed = new Random();
        while (it.hasNext()) {
            String resourceName;
            BundlePath bundlePath = it.nextPath();
            if (bundlePath == null || (resourceName = bundlePath.getPath()) == null) continue;
            int random = -1;
            if (debugOn && this.useRandomParam) {
                random = randomSeed.nextInt();
                if (random < 0) {
                    random *= -1;
                }
                out.write(this.createBundleLink(resourceName, bundlePath.getBundlePrefix(), "d=" + random, contextPath, isSslRequest));
            } else if (!debugOn && bundlePath.isProductionURL()) {
                out.write(this.renderLink(resourceName));
            } else if (!debugOn && useGzip) {
                out.write(this.createGzipBundleLink(resourceName, bundlePath.getBundlePrefix(), contextPath, isSslRequest));
            } else {
                out.write(this.createBundleLink(resourceName, bundlePath.getBundlePrefix(), null, contextPath, isSslRequest));
            }
            if (!debugOn || ctx.getIncludedResources().add(resourceName)) continue;
            this.addComment("The resource '" + resourceName + "' is already included in the page.", out);
        }
    }

    protected final void addComment(String commentText, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer("<script type=\"text/javascript\">/* ");
        sb.append(commentText).append(" */</script>").append("\n");
        out.write(sb.toString());
    }

    protected String createGzipBundleLink(String resourceName, String bundlePrefix, String contextPath, boolean isSslRequest) {
        String resource = resourceName.substring(1, resourceName.length());
        return this.createBundleLink("/gzip_" + resource, bundlePrefix, null, contextPath, isSslRequest);
    }

    protected String createBundleLink(String bundleId, String bundlePrefix, String randomParam, String contextPath, boolean isSslRequest) {
        String path = bundleId;
        String fullPath = null;
        if (this.bundler.getConfig().isDebugModeOn()) {
            if (this.bundler.getConfig().getGeneratorRegistry().isPathGenerated(bundleId)) {
                path = PathNormalizer.createGenerationPath(bundleId, this.bundler.getConfig().getGeneratorRegistry(), randomParam);
            } else if (StringUtils.isNotEmpty(randomParam)) {
                path = bundleId + "?" + randomParam;
            }
            fullPath = PathNormalizer.joinPaths(this.bundler.getConfig().getServletMapping(), path);
        } else {
            fullPath = StringUtils.isNotEmpty(bundlePrefix) ? PathNormalizer.joinPaths(this.bundler.getConfig().getServletMapping(), PathNormalizer.joinPaths(bundlePrefix, path)) : PathNormalizer.joinPaths(this.bundler.getConfig().getServletMapping(), path);
        }
        fullPath = RendererRequestUtils.getRenderedUrl(fullPath, this.bundler.getConfig(), contextPath, isSslRequest);
        if (ThreadLocalJawrContext.isDebugOverriden()) {
            fullPath = PathNormalizer.addGetParameter(fullPath, "overrideKey", this.bundler.getConfig().getDebugOverrideKey());
        }
        return this.renderLink(fullPath);
    }

    protected abstract String renderLink(String var1);
}

