/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.renderer;

import java.io.IOException;
import java.io.Writer;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.renderer.AbstractBundleLinkRenderer;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import net.jawr.web.resource.bundle.renderer.JsBundleLinkRenderer;

public class JavascriptHTMLBundleLinkRenderer
extends AbstractBundleLinkRenderer
implements JsBundleLinkRenderer {
    private static final long serialVersionUID = -7753927288041046690L;
    private static final String PRE_TAG = "<script type=\"text/javascript\" src=\"";
    private static final String SRC_END_ATTRIBUTE = "\"";
    private static final String ASYNC_ATTRIBUTE = " async=\"async\"";
    private static final String DEFER_ATTRIBUTE = " defer=\"defer\"";
    private static final String POST_TAG = " ></script>\n";
    private boolean defer;
    private boolean async;
    private boolean renderGlobalLinks;

    @Override
    public void init(ResourceBundlesHandler bundler, Boolean useRandomParam, Boolean async, Boolean defer) {
        this.init(bundler, useRandomParam);
        if (async != null) {
            this.async = async;
        }
        if (defer != null) {
            this.defer = defer;
        }
    }

    @Override
    public String getResourceType() {
        return "js";
    }

    @Override
    protected void performGlobalBundleLinksRendering(BundleRendererContext ctx, Writer out, boolean debugOn) throws IOException {
        this.renderGlobalLinks = true;
        super.performGlobalBundleLinksRendering(ctx, out, debugOn);
        this.renderGlobalLinks = false;
    }

    @Override
    protected String renderLink(String fullPath) {
        StringBuffer sb = new StringBuffer(PRE_TAG);
        sb.append(fullPath);
        sb.append(SRC_END_ATTRIBUTE);
        if (this.async && !this.renderGlobalLinks) {
            sb.append(ASYNC_ATTRIBUTE);
        }
        if (this.defer && !this.renderGlobalLinks) {
            sb.append(DEFER_ATTRIBUTE);
        }
        sb.append(POST_TAG);
        return sb.toString();
    }
}

