/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.variant;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VariantSet
implements Set<String> {
    private String type;
    private String defaultVariant;
    private Set<String> variants;

    public VariantSet(String type, String defaultVariant, String[] variants) {
        this(type, defaultVariant, Arrays.asList(variants));
    }

    public VariantSet(String type, String defaultVariant, Collection<String> variants) {
        if (!variants.contains(defaultVariant)) {
            throw new IllegalArgumentException("For the variant type '" + type + "', the default variant '" + defaultVariant + "' doesn't exist in the variant set " + variants + ".");
        }
        this.type = type;
        this.defaultVariant = defaultVariant;
        this.variants = new HashSet<String>(variants);
    }

    public VariantSet(String type, String defaultVariant, Set<String> variants) {
        if (!variants.contains(defaultVariant)) {
            throw new IllegalArgumentException("For the variant type '" + type + "', the default variant '" + defaultVariant + "' doesn't exist in the variant set " + variants + ".");
        }
        this.type = type;
        this.defaultVariant = defaultVariant;
        this.variants = variants;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultVariant() {
        return this.defaultVariant;
    }

    public Set<String> getVariants() {
        return this.variants;
    }

    public boolean hasSameDefaultVariant(VariantSet obj) {
        return this.defaultVariant == null && obj.defaultVariant == null || this.defaultVariant != null && this.defaultVariant.equals(obj.defaultVariant);
    }

    @Override
    public boolean add(String arg0) {
        return this.variants.add(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends String> arg0) {
        return this.variants.addAll(arg0);
    }

    @Override
    public void clear() {
        this.variants.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.variants.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.variants.containsAll(coll);
    }

    @Override
    public boolean isEmpty() {
        return this.variants.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.variants.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.variants.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.variants.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.variants.retainAll(coll);
    }

    @Override
    public int size() {
        return this.variants.size();
    }

    @Override
    public Object[] toArray() {
        return this.variants.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.variants.toArray(a);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultVariant == null ? 0 : this.defaultVariant.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.variants == null ? 0 : this.variants.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariantSet other = (VariantSet)obj;
        if (this.defaultVariant == null ? other.defaultVariant != null : !this.defaultVariant.equals(other.defaultVariant)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.variants == null ? other.variants != null : !this.variants.equals(other.variants));
    }
}

