/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.variant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.util.StringUtils;

public class VariantUtils {
    public static List<Map<String, String>> getAllVariants(Map<String, ? extends Collection<String>> variantSets) {
        List<Map<String, String>> variants = new ArrayList<Map<String, String>>();
        if (variantSets != null) {
            for (Map.Entry<String, ? extends Collection<String>> variantEntry : new TreeMap<String, Collection<String>>(variantSets).entrySet()) {
                String variantType = variantEntry.getKey();
                Collection<String> variantList = variantEntry.getValue();
                if (variants.isEmpty()) {
                    variants = VariantUtils.getVariants(null, variantType, variantList);
                    continue;
                }
                ArrayList<Map<String, String>> tmpResult = new ArrayList<Map<String, String>>();
                for (Map<String, String> curVariant : variants) {
                    tmpResult.addAll(VariantUtils.getVariants(curVariant, variantType, variantList));
                }
                variants = tmpResult;
            }
        }
        return variants;
    }

    private static List<Map<String, String>> getVariants(Map<String, String> curVariant, String variantType, Collection<String> variantList) {
        ArrayList<Map<String, String>> variants = new ArrayList<Map<String, String>>();
        for (String variant : variantList) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (curVariant != null) {
                map.putAll(curVariant);
            }
            map.put(variantType, variant);
            variants.add(map);
        }
        return variants;
    }

    public static List<String> getAllVariantKeys(Map<String, ? extends Collection<String>> variants) {
        List<String> variantKeys = new ArrayList<String>();
        for (Collection<String> collection : new TreeMap<String, Collection<String>>(variants).values()) {
            if (variantKeys.isEmpty()) {
                variantKeys = VariantUtils.getVariantKeys(null, collection);
                continue;
            }
            ArrayList<String> tmpResult = new ArrayList<String>();
            for (String curVariantKey : variantKeys) {
                tmpResult.addAll(VariantUtils.getVariantKeys(curVariantKey + '@', collection));
            }
            variantKeys = tmpResult;
        }
        if (variantKeys.isEmpty()) {
            variantKeys.add(null);
        }
        return variantKeys;
    }

    public static List<String> getAllVariantKeysFromFixedVariants(Map<String, VariantSet> variants, Map<String, String> fixedVariants) {
        HashMap<String, VariantSet> tempVariants = new HashMap<String, VariantSet>(variants);
        if (fixedVariants != null) {
            for (Map.Entry<String, String> entry : fixedVariants.entrySet()) {
                VariantSet variantSet = (VariantSet)tempVariants.get(entry.getKey());
                if (variantSet == null) continue;
                String variantValue = variantSet.getDefaultVariant();
                if (variantSet.contains(entry.getValue())) {
                    variantValue = entry.getValue();
                }
                VariantSet newVariantSet = new VariantSet(variantSet.getType(), variantValue, Arrays.asList(variantValue));
                tempVariants.put(variantSet.getType(), newVariantSet);
            }
        }
        return VariantUtils.getAllVariantKeys(tempVariants);
    }

    private static List<String> getVariantKeys(String variantKeyPrefix, Collection<String> variants) {
        ArrayList<String> variantKeys = new ArrayList<String>();
        for (String variant : variants) {
            if (variant == null) {
                variant = "";
            }
            if (variantKeyPrefix == null) {
                variantKeys.add(variant);
                continue;
            }
            variantKeys.add(variantKeyPrefix + variant);
        }
        return variantKeys;
    }

    public static String getVariantKey(Map<String, String> variants) {
        String variantKey = "";
        if (variants != null) {
            variantKey = VariantUtils.getVariantKey(variants, variants.keySet());
        }
        return variantKey;
    }

    public static String getVariantKey(Map<String, String> curVariants, Set<String> variantTypes) {
        String variantKey = "";
        if (curVariants != null && variantTypes != null) {
            TreeMap<String, String> tempVariants = new TreeMap<String, String>(curVariants);
            StringBuffer variantKeyBuf = new StringBuffer();
            for (Map.Entry entry : tempVariants.entrySet()) {
                if (!variantTypes.contains(entry.getKey())) continue;
                String value = (String)entry.getValue();
                if (value == null) {
                    value = "";
                }
                variantKeyBuf.append(value + '@');
            }
            variantKey = variantKeyBuf.toString();
            if (StringUtils.isNotEmpty(variantKey) && variantKey.charAt(variantKey.length() - 1) == '@') {
                variantKey = variantKey.substring(0, variantKey.length() - 1);
            }
        }
        return variantKey;
    }

    public static String getVariantBundleName(String bundleName, String variantKey) {
        String newName = bundleName;
        if (StringUtils.isNotEmpty(variantKey)) {
            int idxSeparator = bundleName.lastIndexOf(46);
            if (idxSeparator != -1) {
                newName = bundleName.substring(0, idxSeparator);
                newName = newName + '@' + variantKey;
                newName = newName + bundleName.substring(idxSeparator);
            } else {
                newName = newName + '@' + variantKey;
            }
        }
        return newName;
    }

    public static String getVariantBundleName(String bundleName, Map<String, String> variants) {
        String variantKey = VariantUtils.getVariantKey(variants);
        return VariantUtils.getVariantBundleName(bundleName, variantKey);
    }

    public static Map<String, VariantSet> concatVariants(Map<String, VariantSet> variantSet1, Map<String, VariantSet> variantSet2) {
        HashMap<String, VariantSet> result = new HashMap<String, VariantSet>();
        if (!VariantUtils.isEmpty(variantSet1) && VariantUtils.isEmpty(variantSet2)) {
            result.putAll(variantSet1);
        } else if (VariantUtils.isEmpty(variantSet1) && !VariantUtils.isEmpty(variantSet2)) {
            result.putAll(variantSet2);
        } else if (!VariantUtils.isEmpty(variantSet1) && !VariantUtils.isEmpty(variantSet2)) {
            HashSet<String> keySet = new HashSet<String>();
            keySet.addAll(variantSet1.keySet());
            keySet.addAll(variantSet2.keySet());
            for (String variantType : keySet) {
                VariantSet variants1 = variantSet1.get(variantType);
                VariantSet variants2 = variantSet2.get(variantType);
                HashSet<String> variants = new HashSet<String>();
                String defaultVariant = null;
                if (variants1 != null && variants2 != null && !variants1.hasSameDefaultVariant(variants2)) {
                    throw new BundlingProcessException("For the variant type '" + variantType + "', the variant sets defined in your bundles don't have the same default value.");
                }
                if (variants1 != null) {
                    variants.addAll(variants1);
                    defaultVariant = variants1.getDefaultVariant();
                }
                if (variants2 != null) {
                    variants.addAll(variants2);
                    defaultVariant = variants2.getDefaultVariant();
                }
                VariantSet variantSet = new VariantSet(variantType, defaultVariant, (Set<String>)variants);
                result.put(variantType, variantSet);
            }
        }
        return result;
    }

    private static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }
}

