/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.handler.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundleContent;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceBundleHandler
implements ResourceBundleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractResourceBundleHandler.class.getName());
    protected static final String TEMP_SUBDIR = "jawrTmp";
    protected static final String TEMP_TEXT_SUBDIR = "text";
    protected static final String TEMP_GZIP_SUBDIR = "gzip";
    protected static final String TEMP_CSS_CLASSPATH_SUBDIR = "cssClasspath";
    protected String tempDirPath;
    protected String textDirPath;
    protected String gzipDirPath;
    protected String cssClasspathDirPath;
    protected Charset charset;
    protected String mappingFileName;
    private String resourceType;
    private boolean useFileSystemTempDir = true;

    protected AbstractResourceBundleHandler(File tempDirRoot, Charset charset, GeneratorRegistry generatorRegistry, String resourceType) {
        this(tempDirRoot, charset, resourceType, true);
    }

    protected AbstractResourceBundleHandler(String tempDirRoot, Charset charset, String resourceType, boolean createTempSubDir) {
        this.resourceType = resourceType;
        this.charset = charset;
        if (StringUtils.isEmpty(resourceType) || resourceType.equals("js")) {
            this.mappingFileName = "jawr-js-mapping.properties";
        } else if (resourceType.equals("css")) {
            this.mappingFileName = "jawr-css-mapping.properties";
        } else if (resourceType.equals("img")) {
            this.mappingFileName = "jawr-img-mapping.properties";
        }
        if (tempDirRoot.startsWith("file://")) {
            tempDirRoot = tempDirRoot.substring("file://".length());
        } else {
            this.useFileSystemTempDir = false;
        }
        this.initTempDirectory(tempDirRoot, createTempSubDir);
    }

    protected AbstractResourceBundleHandler(File tempDirRoot, Charset charset, String resourceType, boolean createTempSubDir) {
        this.resourceType = resourceType;
        this.charset = charset;
        if (StringUtils.isEmpty(resourceType) || resourceType.equals("js")) {
            this.mappingFileName = "jawr-js-mapping.properties";
        } else if (resourceType.equals("css")) {
            this.mappingFileName = "jawr-css-mapping.properties";
        } else if (resourceType.equals("img")) {
            this.mappingFileName = "jawr-img-mapping.properties";
        }
        try {
            this.initTempDirectory(tempDirRoot.getCanonicalPath(), createTempSubDir);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException creating temporary jawr directory", e);
        }
    }

    private void initTempDirectory(String tempDirRoot, boolean createTempSubDir) {
        this.tempDirPath = tempDirRoot;
        if (createTempSubDir) {
            this.tempDirPath = this.tempDirPath + File.separator + TEMP_SUBDIR;
        }
        if (this.tempDirPath.indexOf("%20") != -1) {
            this.tempDirPath = this.tempDirPath.replaceAll("%20", " ");
        }
        this.textDirPath = this.tempDirPath + File.separator + TEMP_TEXT_SUBDIR;
        this.gzipDirPath = this.tempDirPath + File.separator + TEMP_GZIP_SUBDIR;
        this.cssClasspathDirPath = this.tempDirPath + File.separator + TEMP_CSS_CLASSPATH_SUBDIR;
        if (createTempSubDir) {
            try {
                this.createDir(this.tempDirPath);
                this.createDir(this.textDirPath);
                this.createDir(this.gzipDirPath);
                this.createDir(this.cssClasspathDirPath);
            }
            catch (IOException e) {
                throw new BundlingProcessException("Unexpected IOException creating temporary jawr directory", e);
            }
        }
    }

    @Override
    public String getBundleTextDirPath() {
        return this.textDirPath;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public boolean isExistingMappingFile() {
        return this.getBundleMappingStream() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getJawrBundleMapping() {
        Properties bundleMapping = new Properties();
        InputStream is = null;
        try {
            is = this.getBundleMappingStream();
            if (is != null) {
                bundleMapping.load(is);
            } else {
                LOGGER.info("The jawr bundle mapping '" + this.mappingFileName + "' is not found");
            }
        }
        catch (IOException e) {
            LOGGER.info("Error while loading the jawr bundle mapping 'jawr-js-mapping.properties'");
        }
        finally {
            IOUtils.close(is);
        }
        return bundleMapping;
    }

    private InputStream getBundleMappingStream() {
        InputStream is = null;
        try {
            is = this.getTemporaryResourceAsStream(PathNormalizer.concatWebPath(this.tempDirPath + "/", this.mappingFileName));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return is;
    }

    public InputStream getTemporaryResourceAsStream(String resourceName) throws ResourceNotFoundException {
        InputStream is = null;
        if (this.useFileSystemTempDir) {
            File file = new File(resourceName);
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ResourceNotFoundException(resourceName);
            }
        } else {
            is = this.doGetResourceAsStream(resourceName);
        }
        if (is == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        return is;
    }

    protected abstract InputStream doGetResourceAsStream(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJawrBundleMapping(Properties bundleMapping) {
        File bundleMappingFile = new File(this.tempDirPath, this.mappingFileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(bundleMappingFile);
            bundleMapping.store(out, "Jawr mapping");
        }
        catch (IOException e) {
            try {
                LOGGER.error("Unable to store the bundle mapping");
            }
            catch (Throwable throwable) {
                IOUtils.close(out);
                throw throwable;
            }
            IOUtils.close(out);
        }
        IOUtils.close(out);
    }

    @Override
    public ReadableByteChannel getResourceBundleChannel(String bundleName) throws ResourceNotFoundException {
        return this.getResourceBundleChannel(bundleName, true);
    }

    @Override
    public Reader getResourceBundleReader(String bundleName) throws ResourceNotFoundException {
        ReadableByteChannel inchannel = this.getResourceBundleChannel(bundleName, false);
        return Channels.newReader(inchannel, this.charset.newDecoder(), -1);
    }

    public ReadableByteChannel getResourceBundleChannel(String bundleName, boolean gzipBundle) throws ResourceNotFoundException {
        String tempFileName = this.getStoredBundlePath(bundleName, gzipBundle);
        InputStream is = this.getTemporaryResourceAsStream(tempFileName);
        return Channels.newChannel(is);
    }

    private String getStoredBundlePath(String bundleName, boolean asGzippedBundle) {
        String tempFileName = asGzippedBundle ? this.gzipDirPath : this.textDirPath;
        return this.getStoredBundlePath(tempFileName, bundleName);
    }

    private String getStoredBundlePath(String rootDir, String bundleName) {
        if (bundleName.indexOf(47) != -1) {
            bundleName = bundleName.replace('/', File.separatorChar);
        }
        if (!bundleName.startsWith(File.separator)) {
            rootDir = rootDir + File.separator;
        }
        return rootDir + PathNormalizer.escapeToPhysicalPath(bundleName);
    }

    public void storeBundle(String bundleName, StringBuffer bundledResources) {
        JoinableResourceBundleContent bundleResourcesContent = new JoinableResourceBundleContent(bundledResources);
        this.storeBundle(bundleName, bundleResourcesContent);
    }

    @Override
    public void storeBundle(String bundleName, JoinableResourceBundleContent bundleResourcesContent) {
        String bundleContent = bundleResourcesContent.getContent().toString();
        this.storeBundle(bundleName, bundleContent, false, this.textDirPath);
        this.storeBundle(bundleName, bundleContent, true, this.gzipDirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBundle(String bundleName, String bundledResources, boolean gzipFile, String rootdir) {
        if (LOGGER.isDebugEnabled()) {
            String msg = "Storing a generated " + (gzipFile ? "and gzipped" : "") + " bundle with an id of:" + bundleName;
            LOGGER.debug(msg);
        }
        try {
            Writer wr;
            GZIPOutputStream gzOut;
            block8: {
                bundleName = bundleName.replaceAll(":", "_");
                if (bundleName.indexOf(47) != -1) {
                    StringTokenizer tk = new StringTokenizer(bundleName, "/");
                    StringBuffer pathName = new StringBuffer(rootdir);
                    while (tk.hasMoreTokens()) {
                        String name = tk.nextToken();
                        if (!tk.hasMoreTokens()) continue;
                        pathName.append(File.separator + name);
                        this.createDir(pathName.toString());
                    }
                    bundleName = bundleName.replace('/', File.separatorChar);
                }
                File store = this.createNewFile(rootdir + File.separator + bundleName);
                gzOut = null;
                wr = null;
                try {
                    if (gzipFile) {
                        FileOutputStream fos = new FileOutputStream(store);
                        gzOut = new GZIPOutputStream(fos);
                        byte[] data = bundledResources.toString().getBytes(this.charset.name());
                        gzOut.write(data, 0, data.length);
                        break block8;
                    }
                    FileOutputStream fos = new FileOutputStream(store);
                    FileChannel channel = fos.getChannel();
                    wr = Channels.newWriter(channel, this.charset.newEncoder(), -1);
                    wr.write(bundledResources.toString());
                }
                catch (Throwable throwable) {
                    IOUtils.close(gzOut);
                    IOUtils.close(wr);
                    throw throwable;
                }
            }
            IOUtils.close(gzOut);
            IOUtils.close(wr);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BundlingProcessException("Unexpected IOException creating temporary jawr file", e);
        }
    }

    private File createDir(String path) throws IOException {
        File dir;
        if (path.indexOf("%20") != -1) {
            path = path.replaceAll("%20", " ");
        }
        if (!(dir = new File(path)).exists() && !dir.mkdirs()) {
            throw new BundlingProcessException("Error creating temporary jawr directory with path:" + dir.getPath());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created dir: " + dir.getCanonicalPath());
        }
        return dir;
    }

    private File createNewFile(String path) throws IOException {
        File newFile;
        if (path.indexOf("%20") != -1) {
            path = path.replaceAll("%20", " ");
        }
        if (!(newFile = new File(path)).exists() && !newFile.createNewFile()) {
            throw new BundlingProcessException("Unable to create a temporary file at " + path);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created file: " + newFile.getCanonicalPath());
        }
        return newFile;
    }
}

