/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.handler.bundle;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.handler.bundle.AbstractResourceBundleHandler;

public class ServletContextResourceBundleHandler
extends AbstractResourceBundleHandler {
    private ServletContext context;

    public ServletContextResourceBundleHandler(ServletContext context, Charset charset, GeneratorRegistry generatorRegistry, String resourceType) {
        super((File)context.getAttribute("javax.servlet.context.tempdir"), charset, generatorRegistry, resourceType);
        this.context = context;
        this.charset = charset;
    }

    public ServletContextResourceBundleHandler(ServletContext context, String workingDirectory, Charset charset, GeneratorRegistry generatorRegistry, String resourceType) {
        super(workingDirectory, charset, resourceType, false);
        this.context = context;
        this.charset = charset;
    }

    @Override
    public InputStream getResourceBundleAsStream(String bundleName) throws ResourceNotFoundException {
        InputStream is = this.context.getResourceAsStream(bundleName);
        if (is == null) {
            throw new ResourceNotFoundException(bundleName);
        }
        return is;
    }

    @Override
    protected InputStream doGetResourceAsStream(String resourceName) {
        return this.context.getResourceAsStream(resourceName);
    }
}

