/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.handler.reader;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.handler.reader.ServletContextResourceReader;

public class BaseServletContextResourceReader
implements ServletContextResourceReader {
    private ServletContext context;
    private Charset charset;

    @Override
    public void init(ServletContext context, JawrConfig config) {
        this.context = context;
        this.charset = config.getResourceCharset();
    }

    @Override
    public Reader getResource(String resourceName) {
        return this.getResource(resourceName, false);
    }

    @Override
    public Reader getResource(String resourceName, boolean processingBundle) {
        InputStreamReader rd = null;
        InputStream is = this.context.getResourceAsStream(resourceName);
        if (is != null) {
            rd = new InputStreamReader(is, this.charset);
        }
        return rd;
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        return this.getResourceAsStream(resourceName, false);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName, boolean processingBundle) {
        InputStream is = null;
        if (!resourceName.startsWith("/WEB-INF/") && !resourceName.startsWith("/META-INF/")) {
            is = this.context.getResourceAsStream(resourceName);
        }
        return is;
    }

    @Override
    public Set<String> getResourceNames(String path) {
        Set paths = this.context.getResourcePaths(path);
        HashSet<String> names = new HashSet<String>();
        int length = path.length();
        if (null != paths) {
            for (String resourcePath : paths) {
                names.add(resourcePath.substring(length, resourcePath.length()));
            }
        }
        return names;
    }

    @Override
    public boolean isDirectory(String path) {
        Set paths = this.context.getResourcePaths(path);
        return null != paths && paths.size() > 0;
    }
}

