/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.taglib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.JawrLinkRenderingException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.ImageResourcesHandler;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.servlet.RendererRequestUtils;
import net.jawr.web.servlet.util.ImageMIMETypesSupport;
import net.jawr.web.util.Base64Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageTagUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageTagUtils.class);
    private static final String BASE64_KEY_PREFIX = "base64#";
    private static final String DATA_PREFIX = "data:";

    public static String getImageUrl(String imgSrc, boolean base64, ImageResourcesHandler imgRsHandler, HttpServletRequest request, HttpServletResponse response) {
        String imgUrl = null;
        boolean isIE6orIE7 = RendererRequestUtils.isIE7orLess(request);
        imgUrl = !isIE6orIE7 && base64 ? ImageTagUtils.getBase64EncodedImage(imgSrc, imgRsHandler, request) : ImageTagUtils.getImageUrl(imgSrc, imgRsHandler, request, response);
        return imgUrl;
    }

    public static String getImageUrl(String imgSrc, ImageResourcesHandler imgRsHandler, HttpServletRequest request, HttpServletResponse response) {
        String imageServletMapping;
        if (imgRsHandler == null) {
            throw new IllegalStateException("You are using a Jawr image tag while the Jawr Image servlet has not been initialized. Initialization of Jawr Image servlet either failed or never occurred.");
        }
        String contextPath = request.getContextPath();
        imgSrc = ImageTagUtils.getFullImagePath(imgSrc, imgRsHandler, request);
        String newUrl = imgRsHandler.getCacheUrl(imgSrc);
        JawrConfig jawrConfig = imgRsHandler.getConfig();
        if (newUrl == null) {
            try {
                newUrl = CheckSumUtils.getCacheBustedUrl(imgSrc, imgRsHandler.getRsReaderHandler(), jawrConfig);
                imgRsHandler.addMapping(imgSrc, newUrl);
            }
            catch (IOException e) {
                LOGGER.info("Unable to create the checksum for the image '" + imgSrc + "' while generating image tag.");
            }
            catch (ResourceNotFoundException e) {
                LOGGER.info("Unable to find the image '" + imgSrc + "' while generating image tag.");
            }
        }
        if (newUrl == null) {
            newUrl = imgSrc;
        }
        if ("".equals(imageServletMapping = jawrConfig.getServletMapping())) {
            if (newUrl.startsWith("/")) {
                newUrl = newUrl.substring(1);
            }
        } else {
            newUrl = PathNormalizer.joinDomainToPath(imageServletMapping, newUrl);
        }
        boolean sslRequest = RendererRequestUtils.isSslRequest(request);
        newUrl = RendererRequestUtils.getRenderedUrl(newUrl, jawrConfig, contextPath, sslRequest);
        return response.encodeURL(newUrl);
    }

    private static String getFullImagePath(String imgSrc, ImageResourcesHandler imgRsHandler, HttpServletRequest request) {
        int idx;
        String contextPath = request.getContextPath();
        if (!imgRsHandler.getConfig().getGeneratorRegistry().isGeneratedImage(imgSrc) && !imgSrc.startsWith("/") && (idx = (imgSrc = PathNormalizer.concatWebPath(request.getRequestURI(), imgSrc)).indexOf(contextPath)) > -1) {
            imgSrc = imgSrc.substring(idx + contextPath.length());
        }
        return imgSrc;
    }

    public static String getImageUrl(String imgSrc, PageContext pageContext) {
        ImageResourcesHandler imgRsHandler = (ImageResourcesHandler)pageContext.getServletContext().getAttribute("net.jawr.web.resource.bundle.IMG_CONTEXT_ATTRIBUTE");
        if (null == imgRsHandler) {
            throw new JawrLinkRenderingException("You are using a Jawr image tag while the Jawr Image servlet has not been initialized. Initialization of Jawr Image servlet either failed or never occurred.");
        }
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        return ImageTagUtils.getImageUrl(imgSrc, imgRsHandler, request, response);
    }

    public static String getBase64EncodedImage(String imgSrc, ImageResourcesHandler imgRsHandler, HttpServletRequest request) {
        String encodedResult = null;
        if (null == imgRsHandler) {
            throw new JawrLinkRenderingException("You are using a Jawr image tag while the Jawr Image servlet has not been initialized. Initialization of Jawr Image servlet either failed or never occurred.");
        }
        imgSrc = ImageTagUtils.getFullImagePath(imgSrc, imgRsHandler, request);
        encodedResult = imgRsHandler.getCacheUrl(BASE64_KEY_PREFIX + imgSrc);
        if (encodedResult == null) {
            try {
                String fileExtension = FileNameUtils.getExtension(imgSrc);
                String fileMimeType = (String)ImageMIMETypesSupport.getSupportedProperties(ImageTagUtils.class).get(fileExtension);
                InputStream is = imgRsHandler.getRsReaderHandler().getResourceAsStream(imgSrc);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy(is, out, true);
                byte[] data = out.toByteArray();
                encodedResult = new String(Base64Encoder.encode(data));
                encodedResult = DATA_PREFIX + fileMimeType + ";base64," + encodedResult;
                imgRsHandler.addMapping(BASE64_KEY_PREFIX + imgSrc, encodedResult);
            }
            catch (ResourceNotFoundException e) {
                LOGGER.warn("Unable to find the image '" + imgSrc + "' while generating image tag.");
            }
            catch (IOException e) {
                LOGGER.warn("Unable to copy the image '" + imgSrc + "' while generating image tag.");
            }
        }
        return encodedResult;
    }
}

