/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyUtils.class);

    public static String getProperty(Object bean, String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String value = null;
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object result = PropertyUtils.invokeMethod(readMethod, bean, new Object[0]);
        if (result != null) {
            value = result.toString();
        }
        return value;
    }

    private static PropertyDescriptor getPropertyDescriptor(Object bean, String name) {
        PropertyDescriptor descriptor = null;
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean.getClass());
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                descriptor = descriptors[i];
            }
        }
        return descriptor;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method");
        }
        Object[] values = new Object[]{value};
        PropertyUtils.invokeMethod(writeMethod, bean, values);
    }

    private static Object invokeMethod(Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        try {
            return method.invoke(bean, values);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Method invocation failed.", (Throwable)e);
            throw new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " - " + e.getMessage());
        }
    }
}

