/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.cache;

import java.io.InputStream;
import java.io.Serializable;
import net.jawr.web.cache.JawrCacheManager;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheManager
extends JawrCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhCacheManager.class);
    private static final String JAWR_EHCACHE_CONFIG_PATH = "jawr.ehcache.config.path";
    private static final String JAWR_EHCACHE_CACHE_NAME = "jawr.ehcache.cache.name";
    private static final String DEFAULT_EHCACHE_CONFIG_PATH = "ehcache.xml";
    private Cache cache;

    public EhCacheManager(JawrConfig config) {
        super(config);
        String configPath = config.getProperty(JAWR_EHCACHE_CONFIG_PATH, DEFAULT_EHCACHE_CONFIG_PATH);
        String cacheName = config.getProperty(JAWR_EHCACHE_CACHE_NAME);
        try {
            CacheManager cacheMgr = CacheManager.create((InputStream)ClassLoaderResourceUtils.getResourceAsStream(configPath, this));
            this.cache = cacheMgr.getCache(cacheName);
        }
        catch (Exception e) {
            LOGGER.error("Unable to load EHCACHE configuration file", (Throwable)e);
        }
    }

    @Override
    public void put(String key, Object obj) {
        this.cache.put(new Element((Object)key, obj));
    }

    @Override
    public Object get(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    @Override
    public Object remove(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        if (element != null) {
            this.cache.remove((Serializable)((Object)key));
        }
        return element;
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }
}

