/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.config;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import net.jawr.web.JawrConstant;
import net.jawr.web.config.ConfigPropertyResolver;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.generator.variant.css.CssSkinVariantResolver;
import net.jawr.web.resource.bundle.hashcode.BundleHashcodeGenerator;
import net.jawr.web.resource.bundle.hashcode.BundleStringHashcodeGenerator;
import net.jawr.web.resource.bundle.hashcode.MD5BundleHashcodeGenerator;
import net.jawr.web.resource.bundle.locale.DefaultLocaleResolver;
import net.jawr.web.resource.bundle.locale.LocaleResolver;
import net.jawr.web.resource.bundle.locale.LocaleVariantResolverWrapper;
import net.jawr.web.resource.bundle.renderer.CSSHTMLBundleLinkRenderer;
import net.jawr.web.resource.bundle.variant.VariantResolver;
import net.jawr.web.resource.bundle.variant.resolver.BrowserResolver;
import net.jawr.web.resource.bundle.variant.resolver.ConnectionTypeResolver;
import net.jawr.web.servlet.util.MIMETypesSupport;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JawrConfig
implements Serializable {
    private static final long serialVersionUID = -6243263853446050289L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JawrConfig.class);
    private static final List<String> UNAUTHORIZED_RESOURCE_EXTENSIONS = Arrays.asList("xml", "properties", "text");
    public static final Pattern JAWR_PROPERY_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9_\\.\\-]+)}");
    public static final String JAWR_CSSLINKS_FLAVOR = "jawr.csslinks.flavor";
    public static final String JAWR_LOCALE_RESOLVER = "jawr.locale.resolver";
    public static final String JAWR_BROWSER_RESOLVER = "jawr.browser.resolver";
    public static final String JAWR_CSS_SKIN_RESOLVER = "jawr.css.skin.resolver";
    public static final String JAWR_CONNECTION_TYPE_SCHEME_RESOLVER = "jawr.url.connection.type.resolver";
    public static final String JAWR_BUNDLE_HASHCODE_GENERATOR = "jawr.bundle.hashcode.generator";
    public static final String JAWR_DWR_MAPPING = "jawr.dwr.mapping";
    public static final String JAWR_URL_CONTEXTPATH_OVERRIDE = "jawr.url.contextpath.override";
    public static final String JAWR_URL_CONTEXTPATH_SSL_OVERRIDE = "jawr.url.contextpath.ssl.override";
    public static final String JAWR_USE_URL_CONTEXTPATH_OVERRIDE_IN_DEBUG_MODE = "jawr.url.contextpath.override.used.in.debug.mode";
    public static final String JAWR_GZIP_IE6_ON = "jawr.gzip.ie6.on";
    public static final String JAWR_DEBUG_IE_FORCE_CSS_BUNDLE = "jawr.debug.ie.force.css.bundle";
    public static final String JAWR_CHARSET_NAME = "jawr.charset.name";
    public static final String JAWR_GZIP_ON = "jawr.gzip.on";
    public static final String JAWR_DEBUG_OVERRIDE_KEY = "jawr.debug.overrideKey";
    public static final String JAWR_USE_RANDOM_PARAM = "jawr.debug.use.random.parameter";
    private static final String JAWR_CONFIG_RELOAD_REFRESH_KEY = "jawr.config.reload.refreshKey";
    public static final String JAWR_DEBUG_ON = "jawr.debug.on";
    public static final String JAWR_WORKING_DIRECTORY = "jawr.working.directory";
    public static final String JAWR_USE_BUNDLE_MAPPING = "jawr.use.bundle.mapping";
    private static final String DEBUG_MODE_SYSTEM_FLAG = "net.jawr.debug.on";
    public static final String JAWR_JS_CLIENTSIDE_HANDLER = "jawr.js.clientside.handler.generator.class";
    public static final String JAWR_JS_BUNDLE_LINK_RENDERER_CLASS = "jawr.js.bundle.link.renderer.class";
    public static final String JAWR_CSS_BUNDLE_LINK_RENDERER_CLASS = "jawr.css.bundle.link.renderer.class";
    public static final String JAWR_IMG_RENDERER_CLASS = "jawr.img.bundle.link.renderer.class";
    public static final String JAWR_CSS_CLASSPATH_HANDLE_IMAGE = "jawr.css.classpath.handle.image";
    public static final String JAWR_CSS_SKIN_COOKIE = "jawr.css.skin.cookie";
    public static final String JAWR_BINARY_HASH_ALGORITHM = "jawr.binary.hash.algorithm";
    public static final String JAWR_BINARY_RESOURCES = "jawr.binary.resources";
    public static final String JAWR_STRICT_MODE = "jawr.strict.mode";
    public static final String JAWR_SERVLET_CTX_READER_CLASS = "jawr.servlet.context.reader.class";
    private GeneratorRegistry generatorRegistry;
    private LocaleResolver localeResolver;
    private BundleHashcodeGenerator bundleHashcodeGenerator;
    private ServletContext context;
    private Properties configProperties;
    private String charsetName = "UTF-8";
    private Charset resourceCharset;
    private boolean strictMode = false;
    private boolean debugModeOn = false;
    private boolean debugUseRandomParam = true;
    private String debugOverrideKey = "";
    private String refreshKey = "";
    private boolean gzipResourcesModeOn = true;
    private boolean gzipResourcesForIESixOn = true;
    private boolean forceCssBundleInDebugForIEOn = false;
    private boolean useBundleMapping = false;
    private String jawrWorkingDirectory;
    private String servletMapping = "";
    private String resourceType;
    private List<String> allowedExtensions = new ArrayList<String>();
    private String contextPathOverride;
    private String contextPathSslOverride;
    private String clientSideHandlerGeneratorClass;
    private boolean useContextPathOverrideInDebugMode = false;
    private boolean classpathCssHandleImage = false;
    private String binaryResourcesDefinition;
    private String binaryHashAlgorithm = "CRC32";
    private boolean valid = true;
    private String dwrMapping;
    private String skinCookieName = "jawrSkin";
    private String servletContextRsReaderClass;
    private String jsBundleLinkRenderClass;
    private String cssBundleLinkRenderClass;
    private String imgRenderClass;

    public JawrConfig(String resourceType, Properties props) {
        this(resourceType, props, null);
    }

    public JawrConfig(String resourceType, Properties props, ConfigPropertyResolver resolver) {
        this.resourceType = resourceType;
        this.configProperties = props;
        if (resolver != null) {
            for (Map.Entry<Object, Object> entry : this.configProperties.entrySet()) {
                String value = (String)entry.getValue();
                Matcher matcher = JAWR_PROPERY_PLACEHOLDER_PATTERN.matcher(value);
                StringBuffer sb = new StringBuffer();
                boolean resolved = false;
                while (matcher.find()) {
                    String resolvedValue = resolver.resolve(matcher.group(1));
                    if (value == null) {
                        resolvedValue = matcher.group(1);
                        LOGGER.warn("The property '" + matcher.group(1) + "' has not been resolved. Please make sure that your configuration is correct.");
                    } else {
                        resolved = true;
                    }
                    matcher.appendReplacement(sb, RegexUtil.adaptReplacementToMatcher(resolvedValue));
                }
                matcher.appendTail(sb);
                if (!resolved) continue;
                entry.setValue(sb.toString());
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("The property '" + entry.getKey() + "' has been resolved to : " + entry.getValue());
            }
        }
        this.debugModeOn = this.getBooleanProperty(JAWR_DEBUG_ON, false);
        if (null != System.getProperty(DEBUG_MODE_SYSTEM_FLAG)) {
            this.debugModeOn = Boolean.valueOf(System.getProperty(DEBUG_MODE_SYSTEM_FLAG));
        }
        this.debugOverrideKey = this.getProperty(JAWR_DEBUG_OVERRIDE_KEY, "");
        this.debugUseRandomParam = this.getBooleanProperty(JAWR_USE_RANDOM_PARAM, true);
        this.strictMode = this.getBooleanProperty(JAWR_STRICT_MODE, false);
        if (null != props.getProperty("jawr." + resourceType + ".allowed.extensions")) {
            String[] strExtensions;
            for (String extension : strExtensions = props.getProperty("jawr." + resourceType + ".allowed.extensions").split(",")) {
                if (UNAUTHORIZED_RESOURCE_EXTENSIONS.contains(extension)) {
                    LOGGER.warn("The extension '" + extension + "' is an unauthorized extension. It will not be added to the allowed extension.");
                    continue;
                }
                this.allowedExtensions.add(extension);
            }
        }
        if (resourceType.equals("binary")) {
            for (Object key : MIMETypesSupport.getSupportedProperties(this).keySet()) {
                if (this.allowedExtensions.contains((String)key)) continue;
                this.allowedExtensions.add((String)key);
            }
        } else if (!this.allowedExtensions.contains(resourceType)) {
            this.allowedExtensions.add(resourceType);
        }
        this.useBundleMapping = this.getBooleanProperty(JAWR_USE_BUNDLE_MAPPING, false);
        this.jawrWorkingDirectory = this.getProperty(JAWR_WORKING_DIRECTORY);
        this.gzipResourcesModeOn = this.getBooleanProperty(JAWR_GZIP_ON, true);
        this.setCharsetName(this.getProperty(JAWR_CHARSET_NAME, "UTF-8"));
        this.gzipResourcesForIESixOn = this.getBooleanProperty(JAWR_GZIP_IE6_ON, true);
        this.forceCssBundleInDebugForIEOn = this.getBooleanProperty(JAWR_DEBUG_IE_FORCE_CSS_BUNDLE, false);
        this.contextPathOverride = this.getProperty(JAWR_URL_CONTEXTPATH_OVERRIDE);
        this.contextPathSslOverride = this.getProperty(JAWR_URL_CONTEXTPATH_SSL_OVERRIDE);
        this.useContextPathOverrideInDebugMode = this.getBooleanProperty(JAWR_USE_URL_CONTEXTPATH_OVERRIDE_IN_DEBUG_MODE, false);
        this.refreshKey = this.getProperty(JAWR_CONFIG_RELOAD_REFRESH_KEY, "");
        this.dwrMapping = this.getProperty(JAWR_DWR_MAPPING);
        String localResolverClassName = this.getProperty(JAWR_LOCALE_RESOLVER, DefaultLocaleResolver.class.getName());
        this.localeResolver = (LocaleResolver)ClassLoaderResourceUtils.buildObjectInstance(localResolverClassName);
        String bundleHashCodeGenerator = props.getProperty(JAWR_BUNDLE_HASHCODE_GENERATOR, "").trim();
        this.bundleHashcodeGenerator = bundleHashCodeGenerator.length() == 0 || "default".equalsIgnoreCase(bundleHashCodeGenerator) ? new BundleStringHashcodeGenerator() : ("MD5".equalsIgnoreCase(bundleHashCodeGenerator) ? new MD5BundleHashcodeGenerator() : (BundleHashcodeGenerator)ClassLoaderResourceUtils.buildObjectInstance(bundleHashCodeGenerator));
        this.clientSideHandlerGeneratorClass = this.getProperty(JAWR_JS_CLIENTSIDE_HANDLER, JawrConstant.DEFAULT_JS_CLIENTSIDE_HANDLER_CLASS);
        this.jsBundleLinkRenderClass = this.getProperty(JAWR_JS_BUNDLE_LINK_RENDERER_CLASS, JawrConstant.DEFAULT_JS_BUNDLE_LINK_RENDERER_CLASS);
        this.cssBundleLinkRenderClass = this.getProperty(JAWR_CSS_BUNDLE_LINK_RENDERER_CLASS, JawrConstant.DEFAULT_CSS_BUNDLE_LINK_RENDERER_CLASS);
        this.imgRenderClass = this.getProperty(JAWR_IMG_RENDERER_CLASS, JawrConstant.DEFAULT_IMG_RENDERER_CLASS);
        this.servletContextRsReaderClass = this.getProperty(JAWR_SERVLET_CTX_READER_CLASS, JawrConstant.DEFAULT_SERVLET_CTX_RESOURCE_READER_CLASS);
        this.skinCookieName = this.getProperty(JAWR_CSS_SKIN_COOKIE, "jawrSkin");
        String cssLinkFlavor = this.getProperty(JAWR_CSSLINKS_FLAVOR);
        if (null != cssLinkFlavor) {
            this.setCssLinkFlavor(cssLinkFlavor);
        }
        this.classpathCssHandleImage = this.getBooleanProperty(JAWR_CSS_CLASSPATH_HANDLE_IMAGE, false);
        this.binaryHashAlgorithm = this.getProperty(JAWR_BINARY_HASH_ALGORITHM, "CRC32");
        this.binaryResourcesDefinition = this.getProperty(JAWR_BINARY_RESOURCES);
        if (StringUtils.isNotEmpty(this.getProperty("jawr.css.image.classpath.use.servlet"))) {
            throw new BundlingProcessException("The property 'jawr.css.image.classpath.use.servlet' is not supported anymore, please use 'jawr.css.classpath.handle.image' instead.");
        }
        if (StringUtils.isNotEmpty(this.getProperty("jawr.css.image.classpath.use.servlet"))) {
            throw new BundlingProcessException("The property 'jawr.css.image.classpath.use.servlet' is not supported anymore, please use 'jawr.css.classpath.handle.image' instead.");
        }
        if (StringUtils.isNotEmpty(this.getProperty("jawr.image.hash.algorithm"))) {
            throw new BundlingProcessException("The property 'jawr.image.hash.algorithm' is not supported anymore, please use 'jawr.binary.hash.algorithm' instead.");
        }
        if (StringUtils.isNotEmpty(this.getProperty("jawr.image.resources"))) {
            throw new BundlingProcessException("The property 'jawr.image.resources' is not supported anymore, please use 'jawr.binary.resources' instead.");
        }
    }

    public String getClientSideHandlerGeneratorClass() {
        return this.clientSideHandlerGeneratorClass;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public List<String> getAllowedExtensions() {
        return this.allowedExtensions;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public String getDebugOverrideKey() {
        return this.debugOverrideKey;
    }

    public void setDebugOverrideKey(String debugOverrideKey) {
        this.debugOverrideKey = debugOverrideKey;
    }

    public boolean isDebugUseRandomParam() {
        return this.debugUseRandomParam;
    }

    public void setDebugUseRandomParam(boolean debugUseRandomParam) {
        this.debugUseRandomParam = debugUseRandomParam;
    }

    public boolean isDebugModeOn() {
        if (!this.debugModeOn && ThreadLocalJawrContext.isDebugOverriden()) {
            return true;
        }
        return this.debugModeOn;
    }

    public void setDebugModeOn(boolean debugMode) {
        this.debugModeOn = debugMode;
    }

    public String getRefreshKey() {
        return this.refreshKey;
    }

    public void setRefreshKey(String refreshKey) {
        this.refreshKey = refreshKey;
    }

    public String getJawrWorkingDirectory() {
        return this.jawrWorkingDirectory;
    }

    public void setJawrWorkingDirectory(String dirPath) {
        this.jawrWorkingDirectory = dirPath;
    }

    public boolean getUseBundleMapping() {
        return this.useBundleMapping;
    }

    public void setUseBundleMapping(boolean useBundleMapping) {
        this.useBundleMapping = useBundleMapping;
    }

    public Charset getResourceCharset() {
        if (null == this.resourceCharset) {
            this.resourceCharset = Charset.forName(this.charsetName);
        }
        return this.resourceCharset;
    }

    public final void setCharsetName(String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException("The specified charset [" + charsetName + "] is not supported by the jvm.");
        }
        this.charsetName = charsetName;
    }

    public BundleHashcodeGenerator getBundleHashcodeGenerator() {
        return this.bundleHashcodeGenerator;
    }

    public String getServletMapping() {
        return this.servletMapping;
    }

    public void setServletMapping(String servletMapping) {
        this.servletMapping = PathNormalizer.normalizePath(servletMapping);
    }

    public boolean isGzipResourcesModeOn() {
        return this.gzipResourcesModeOn;
    }

    public void setGzipResourcesModeOn(boolean gzipResourcesModeOn) {
        this.gzipResourcesModeOn = gzipResourcesModeOn;
    }

    public boolean isGzipResourcesForIESixOn() {
        return this.gzipResourcesForIESixOn;
    }

    public void setGzipResourcesForIESixOn(boolean gzipResourcesForIESixOn) {
        this.gzipResourcesForIESixOn = gzipResourcesForIESixOn;
    }

    public boolean isForceCssBundleInDebugForIEOn() {
        return this.forceCssBundleInDebugForIEOn;
    }

    public void setForceCssBundleInDebugForIEOn(boolean forceBundleCssForIEOn) {
        this.forceCssBundleInDebugForIEOn = forceBundleCssForIEOn;
    }

    public String getContextPathOverride() {
        return this.contextPathOverride;
    }

    public void setContextPathOverride(String contextPathOverride) {
        this.contextPathOverride = contextPathOverride;
    }

    public String getContextPathSslOverride() {
        return this.contextPathSslOverride;
    }

    public void setContextPathSslOverride(String contextPathSslOverride) {
        this.contextPathSslOverride = contextPathSslOverride;
    }

    public boolean isUseContextPathOverrideInDebugMode() {
        return this.useContextPathOverrideInDebugMode;
    }

    public void setUseContextPathOverrideInDebugMode(boolean useContextPathOverrideInDebugMode) {
        this.useContextPathOverrideInDebugMode = useContextPathOverrideInDebugMode;
    }

    public String getJsBundleLinkRenderClass() {
        return this.jsBundleLinkRenderClass;
    }

    public void setJsBundleLinkRenderClass(String jsBundleLinkRenderClass) {
        this.jsBundleLinkRenderClass = jsBundleLinkRenderClass;
    }

    public String getCssBundleLinkRenderClass() {
        return this.cssBundleLinkRenderClass;
    }

    public void setCssBundleLinkRenderClass(String cssBundleLinkRenderClass) {
        this.cssBundleLinkRenderClass = cssBundleLinkRenderClass;
    }

    public String getImgRendererClass() {
        return this.imgRenderClass;
    }

    public void setImgRendererClass(String imgRenderClass) {
        this.imgRenderClass = imgRenderClass;
    }

    public String getServletContextResourceReaderClass() {
        return this.servletContextRsReaderClass;
    }

    public void setServletContextResourceReaderClass(String servletContextReaderClass) {
        this.servletContextRsReaderClass = servletContextReaderClass;
    }

    public boolean isCssClasspathImageHandledByClasspathCss() {
        return this.classpathCssHandleImage;
    }

    public void setCssClasspathImageHandledByClasspathCss(boolean classpathCssHandleImage) {
        this.classpathCssHandleImage = classpathCssHandleImage;
    }

    public String getBinaryHashAlgorithm() {
        return this.binaryHashAlgorithm;
    }

    public void setBinaryHashAlgorithm(String binaryHashAlgorithm) {
        this.binaryHashAlgorithm = binaryHashAlgorithm;
    }

    public String getBinaryResourcesDefinition() {
        return this.binaryResourcesDefinition;
    }

    public void setBinaryResourcesDefinition(String binaryResourcesDefinition) {
        this.binaryResourcesDefinition = binaryResourcesDefinition;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public GeneratorRegistry getGeneratorRegistry() {
        return this.generatorRegistry;
    }

    public void setGeneratorRegistry(GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
        this.generatorRegistry.setConfig(this);
        this.localeResolver = null;
        this.localeResolver = this.configProperties.getProperty(JAWR_LOCALE_RESOLVER) == null ? new DefaultLocaleResolver() : (LocaleResolver)ClassLoaderResourceUtils.buildObjectInstance(this.configProperties.getProperty(JAWR_LOCALE_RESOLVER));
        this.generatorRegistry.registerVariantResolver(new LocaleVariantResolverWrapper(this.localeResolver));
        this.registerResolver(new BrowserResolver(), JAWR_BROWSER_RESOLVER);
        this.registerResolver(new ConnectionTypeResolver(), JAWR_CONNECTION_TYPE_SCHEME_RESOLVER);
        this.registerResolver(new CssSkinVariantResolver(), JAWR_CSS_SKIN_RESOLVER);
    }

    private VariantResolver registerResolver(VariantResolver defaultResolver, String configPropertyName) {
        VariantResolver resolver = null;
        resolver = this.configProperties.getProperty(configPropertyName) == null ? defaultResolver : (VariantResolver)ClassLoaderResourceUtils.buildObjectInstance(this.configProperties.getProperty(configPropertyName));
        this.generatorRegistry.registerVariantResolver(resolver);
        return resolver;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public String getDwrMapping() {
        return this.dwrMapping;
    }

    public void setDwrMapping(String dwrMapping) {
        this.dwrMapping = dwrMapping;
    }

    public Properties getConfigProperties() {
        return this.configProperties;
    }

    public final void setCssLinkFlavor(String cssLinkFlavor) {
        if (!("html".equalsIgnoreCase(cssLinkFlavor) || "xhtml".equalsIgnoreCase(cssLinkFlavor) || "xhtml_ext".equalsIgnoreCase(cssLinkFlavor))) {
            throw new IllegalArgumentException("The value for the jawr.csslinks.flavor property [" + cssLinkFlavor + "] is invalid. " + "Please check the docs for valid values ");
        }
        CSSHTMLBundleLinkRenderer.setClosingTag(cssLinkFlavor);
    }

    public boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(propertyName, Boolean.toString(defaultValue)));
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        String property = this.configProperties.getProperty(key, defaultValue);
        if (property != null) {
            property = property.trim();
        }
        return property;
    }

    public boolean isWorkingDirectoryInWebApp() {
        return this.useBundleMapping && StringUtils.isNotEmpty(this.jawrWorkingDirectory) && !this.jawrWorkingDirectory.startsWith("file://");
    }

    public String getSkinCookieName() {
        return this.skinCookieName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(65);
        sb.append("[JawrConfig:'charset name:'").append(this.charsetName).append("'\ndebugModeOn:'").append(this.isDebugModeOn()).append("'\nservletMapping:'").append(this.getServletMapping()).append("' ]");
        return sb.toString();
    }
}

