/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.config.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import net.jawr.web.config.jmx.JawrApplicationConfigManager;
import net.jawr.web.config.jmx.JawrConfigManagerMBean;
import net.jawr.web.exception.JmxConfigException;
import net.jawr.web.util.ServletContextUtils;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxUtils.class);
    private static final String DEFAULT_PREFIX = "default";
    private static final String JAWR_APP_CONFIG_MANAGER_TYPE = "JawrAppConfigManager";
    private static final String JAWR_CONFIG_MANAGER_TYPE = "JawrConfigManager";

    private JmxUtils() {
    }

    public static void initJMXBean(JawrApplicationConfigManager appConfigMgr, ServletContext servletContext, String resourceType, String mBeanPrefix) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs != null) {
                ObjectName jawrConfigMgrObjName = JmxUtils.getMBeanObjectName(servletContext, resourceType, mBeanPrefix);
                ObjectName appJawrMgrObjectName = JmxUtils.getAppJawrConfigMBeanObjectName(servletContext, mBeanPrefix);
                if (!mbs.isRegistered(appJawrMgrObjectName)) {
                    mbs.registerMBean(appConfigMgr, appJawrMgrObjectName);
                }
                if (mbs.isRegistered(jawrConfigMgrObjName)) {
                    LOGGER.warn("The MBean '" + jawrConfigMgrObjName.getCanonicalName() + "' already exists. It will be unregisterd and registered with the new JawrConfigManagerMBean.");
                    mbs.unregisterMBean(jawrConfigMgrObjName);
                }
                JawrConfigManagerMBean configMgr = appConfigMgr.getConfigMgr(resourceType);
                mbs.registerMBean(configMgr, jawrConfigMgrObjName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to instanciate the Jawr MBean for resource type '" + resourceType + "'", (Throwable)e);
        }
    }

    public static MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static ObjectName getMBeanObjectName(ServletContext servletContext, String resourceType, String mBeanPrefix) {
        String contextPath = ServletContextUtils.getContextPath(servletContext);
        return JmxUtils.getJawrConfigMBeanObjectName(contextPath, resourceType, mBeanPrefix);
    }

    public static ObjectName getJawrConfigMBeanObjectName(String contextPath, String resourceType, String mBeanPrefix) {
        return JmxUtils.getMBeanObjectName(contextPath, JAWR_CONFIG_MANAGER_TYPE, mBeanPrefix, resourceType);
    }

    public static ObjectName getAppJawrConfigMBeanObjectName(ServletContext servletContext, String mBeanPrefix) {
        return JmxUtils.getMBeanObjectName(ServletContextUtils.getContextPath(servletContext), JAWR_APP_CONFIG_MANAGER_TYPE, mBeanPrefix, null);
    }

    private static ObjectName getMBeanObjectName(String contextPath, String objectType, String mBeanPrefix, String resourceType) {
        String prefix;
        String curCtxPath = contextPath;
        if (StringUtils.isEmpty(curCtxPath)) {
            curCtxPath = ServletContextUtils.getContextPath(null);
        }
        if (curCtxPath.charAt(0) == '/') {
            curCtxPath = curCtxPath.substring(1);
        }
        if ((prefix = mBeanPrefix) == null) {
            prefix = DEFAULT_PREFIX;
        }
        StringBuilder objectNameStr = new StringBuilder("net.jawr.web.jmx:type=" + objectType + ",prefix=" + prefix + ",webappContext=" + curCtxPath);
        if (resourceType != null) {
            objectNameStr.append(",name=" + resourceType + "MBean");
        }
        return JmxUtils.getObjectName(objectNameStr.toString());
    }

    private static ObjectName getObjectName(String name) {
        ObjectName mBeanName = null;
        try {
            mBeanName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new JmxConfigException(e);
        }
        catch (NullPointerException e) {
            throw new JmxConfigException(e);
        }
        return mBeanName;
    }
}

