/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class BinaryResourcesHandler {
    private final Map<String, String> binaryResourcePathMap = new ConcurrentHashMap<String, String>();
    private final JawrConfig jawrConfig;
    private final ResourceReaderHandler rsHandler;
    private final ResourceBundleHandler rsBundleHandler;

    public BinaryResourcesHandler(JawrConfig config, ResourceReaderHandler rsHandler, ResourceBundleHandler rsBundleHandler) {
        this.jawrConfig = config;
        this.rsHandler = rsHandler;
        this.rsBundleHandler = rsBundleHandler;
    }

    public JawrConfig getConfig() {
        return this.jawrConfig;
    }

    public ResourceReaderHandler getRsReaderHandler() {
        return this.rsHandler;
    }

    public ResourceBundleHandler getRsBundleHandler() {
        return this.rsBundleHandler;
    }

    public Map<String, String> getBinaryPathMap() {
        return this.binaryResourcePathMap;
    }

    public void addMapping(String binaryUrl, String cacheUrl) {
        this.binaryResourcePathMap.put(binaryUrl, cacheUrl);
    }

    public String getCacheUrl(String binaryUrl) {
        return this.binaryResourcePathMap.get(binaryUrl);
    }

    public void clear() {
        this.binaryResourcePathMap.clear();
    }

    public boolean containsValidBundleHashcode(String requestedPath) {
        return this.binaryResourcePathMap.containsValue(requestedPath);
    }
}

