/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.jawr.web.servlet.util.MIMETypesSupport;

public class FileNameUtils {
    private static Set<Object> IMG_EXTENSIONS = MIMETypesSupport.getSupportedProperties(FileNameUtils.class).keySet();
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = new Character('.').toString();
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileNameUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtils.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static String getBaseName(String filename) {
        return FileNameUtils.removeExtension(FileNameUtils.getName(filename));
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtils.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtils.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static boolean isExtension(String filename, String extension) {
        if (filename == null) {
            return false;
        }
        if (extension == null || extension.length() == 0) {
            return FileNameUtils.indexOfExtension(filename) == -1;
        }
        String fileExt = FileNameUtils.getExtension(filename);
        return fileExt.equals(extension);
    }

    public static boolean isExtension(String filename, String[] extensions) {
        if (filename == null) {
            return false;
        }
        if (extensions == null || extensions.length == 0) {
            return FileNameUtils.indexOfExtension(filename) == -1;
        }
        String fileExt = FileNameUtils.getExtension(filename);
        for (int i = 0; i < extensions.length; ++i) {
            if (!fileExt.equals(extensions[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtension(String filename, Collection<Object> extensions) {
        if (filename == null) {
            return false;
        }
        if (extensions == null || extensions.isEmpty()) {
            return FileNameUtils.indexOfExtension(filename) == -1;
        }
        String fileExt = FileNameUtils.getExtension(filename);
        Iterator<Object> it = extensions.iterator();
        while (it.hasNext()) {
            if (!fileExt.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasImageExtension(String filename) {
        return FileNameUtils.isExtension(filename, IMG_EXTENSIONS);
    }
}

