/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public final class CheckSumUtils {
    public static String getCacheBustedUrl(String url, ResourceReaderHandler rsReader, JawrConfig jawrConfig) throws IOException, ResourceNotFoundException {
        String checksum = null;
        InputStream is = null;
        boolean generatedBinaryResource = jawrConfig.getGeneratorRegistry().isGeneratedBinaryResource(url);
        try {
            if (!generatedBinaryResource) {
                url = PathNormalizer.asPath(url);
            }
            if ((is = rsReader.getResourceAsStream(url)) == null) {
                throw new ResourceNotFoundException(url);
            }
            checksum = CheckSumUtils.getChecksum(is, jawrConfig.getBinaryHashAlgorithm());
        }
        catch (FileNotFoundException e) {
            try {
                throw new ResourceNotFoundException(url);
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                throw throwable;
            }
        }
        IOUtils.close(is);
        String result = "";
        result = "cb";
        if (generatedBinaryResource) {
            int idx = url.indexOf(":");
            String generatorPrefix = url.substring(0, idx);
            url = url.substring(idx + 1);
            result = generatorPrefix + "_cb";
        }
        result = result + checksum;
        if (!url.startsWith("/")) {
            result = result + "/";
        }
        return PathNormalizer.asPath(result + url);
    }

    public static String getChecksum(InputStream is, String algorithm) throws IOException {
        if (algorithm.equals("CRC32")) {
            return CheckSumUtils.getCRC32Checksum(is);
        }
        if (algorithm.equals("MD5")) {
            return CheckSumUtils.getMD5Checksum(is);
        }
        throw new BundlingProcessException("The checksum algorithm '" + algorithm + "' is not supported.\n" + "The only supported algorithm are 'CRC32' or 'MD5'.");
    }

    public static String getCRC32Checksum(InputStream is) throws IOException {
        CRC32 checksum = new CRC32();
        byte[] bytes = new byte[1024];
        int len = 0;
        while ((len = is.read(bytes)) >= 0) {
            checksum.update(bytes, 0, len);
        }
        return Long.toString(checksum.getValue());
    }

    public static String getMD5Checksum(String str, Charset charset) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(charset.name()));
        return CheckSumUtils.getMD5Checksum(is);
    }

    public static String getMD5Checksum(InputStream is) throws IOException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestInputStream digestIs = new DigestInputStream(is, md);
            while (((InputStream)digestIs).read() != -1) {
            }
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BundlingProcessException("MD5 algorithm needs to be installed", e);
        }
        return new BigInteger(1, digest).toString(16);
    }
}

