/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IOUtils {
    private static final int BUFFER_SIZE = 16384;

    public static void copy(Reader reader, Writer writer) throws IOException {
        IOUtils.copy(reader, writer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader reader, Writer writer, boolean closeStreams) throws IOException {
        char[] buf = new char[16384];
        int num = 0;
        try {
            while ((num = reader.read(buf, 0, buf.length)) != -1) {
                writer.write(buf, 0, num);
            }
        }
        finally {
            if (closeStreams) {
                IOUtils.close(reader);
                IOUtils.close(writer);
            }
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[16384];
        int num = 0;
        while ((num = input.read(buf, 0, buf.length)) != -1) {
            output.write(buf, 0, num);
        }
    }

    public static void copy(InputStream input, Writer writer) throws IOException {
        IOUtils.copy(new InputStreamReader(input), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output, boolean closeStreams) throws IOException {
        try {
            IOUtils.copy(input, output);
        }
        finally {
            if (closeStreams) {
                IOUtils.close(input);
                IOUtils.close(output);
            }
        }
    }

    public static void write(byte[] byteArray, OutputStream out) throws IOException {
        if (byteArray != null) {
            out.write(byteArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ReadableByteChannel inChannel, WritableByteChannel outChannel) throws IOException {
        if (inChannel instanceof FileChannel) {
            ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), outChannel);
        } else {
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            try {
                while (inChannel.read(buffer) != -1) {
                    buffer.flip();
                    outChannel.write(buffer);
                    buffer.compact();
                }
                buffer.flip();
                while (buffer.hasRemaining()) {
                    outChannel.write(buffer);
                }
            }
            finally {
                IOUtils.close(inChannel);
                IOUtils.close(outChannel);
            }
        }
    }

    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(Reader rd) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(rd, (Writer)sw);
        return sw.toString();
    }
}

