/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.postprocess.ChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.util.StringUtils;

public class JoinableResourceBundlePropertySerializer {
    public static void serializeInProperties(JoinableResourceBundle bundle, String type, Properties props) {
        Set<String> licensesPathList;
        List<JoinableResourceBundle> dependencies;
        String bundleHashcode;
        Map<String, VariantSet> variants;
        if (StringUtils.isEmpty(bundle.getId())) {
            return;
        }
        String bundleName = bundle.getName();
        String prefix = "jawr." + type + "." + "bundle." + bundleName;
        InclusionPattern inclusion = bundle.getInclusionPattern();
        props.put(prefix + ".id", bundle.getId());
        if (StringUtils.isNotEmpty(bundle.getBundlePrefix())) {
            props.put(prefix + ".bundle.prefix", bundle.getBundlePrefix());
        }
        props.put(prefix + ".id", bundle.getId());
        if (inclusion.isGlobal()) {
            props.put(prefix + ".global", Boolean.toString(inclusion.isGlobal()));
        }
        if (inclusion.getInclusionOrder() != 0) {
            props.put(prefix + ".order", Integer.toString(inclusion.getInclusionOrder()));
        }
        if (inclusion.isIncludeOnlyOnDebug()) {
            props.put(prefix + ".debugonly", Boolean.toString(inclusion.isIncludeOnlyOnDebug()));
        }
        if (inclusion.isExcludeOnDebug()) {
            props.put(prefix + ".debugnever", Boolean.toString(inclusion.isExcludeOnDebug()));
        }
        if (StringUtils.isNotEmpty(bundle.getExplorerConditionalExpression())) {
            props.put(prefix + ".ieonly.condition", bundle.getExplorerConditionalExpression());
        }
        if (StringUtils.isNotEmpty(bundle.getAlternateProductionURL())) {
            props.put(prefix + ".productionURL", bundle.getAlternateProductionURL());
        }
        if (bundle.getBundlePostProcessor() != null) {
            props.put(prefix + ".bundlepostprocessors", JoinableResourceBundlePropertySerializer.getBundlePostProcessorsName((ChainedResourceBundlePostProcessor)bundle.getBundlePostProcessor()));
        }
        if (bundle.getUnitaryPostProcessor() != null) {
            props.put(prefix + ".filepostprocessors", JoinableResourceBundlePropertySerializer.getBundlePostProcessorsName((ChainedResourceBundlePostProcessor)bundle.getUnitaryPostProcessor()));
        }
        if ((variants = bundle.getVariants()) != null && !variants.isEmpty()) {
            String serializedVariants = JoinableResourceBundlePropertySerializer.serializeVariantSets(variants);
            if (StringUtils.isNotEmpty(serializedVariants)) {
                props.put(prefix + ".variants", serializedVariants);
            }
            List<String> variantKeys = bundle.getVariantKeys();
            for (String variantKey : variantKeys) {
                if (!StringUtils.isNotEmpty(variantKey)) continue;
                props.put(prefix + ".bundleHashcode." + variantKey, bundle.getBundleDataHashCode(variantKey));
            }
        }
        if ((bundleHashcode = bundle.getBundleDataHashCode(null)) != null) {
            props.put(prefix + ".bundleHashcode", bundleHashcode);
        }
        List<BundlePath> itemPathList = null;
        if (!bundle.getInclusionPattern().isIncludeOnDebug()) {
            itemPathList = bundle.getItemPathList();
        } else if (!bundle.getInclusionPattern().isExcludeOnDebug()) {
            itemPathList = bundle.getItemDebugPathList();
        }
        if (itemPathList != null && !itemPathList.isEmpty()) {
            props.put(prefix + ".mappings", JoinableResourceBundlePropertySerializer.getCommaSeparatedStringForBundlePath(itemPathList));
        }
        if ((dependencies = bundle.getDependencies()) != null && !dependencies.isEmpty()) {
            List<String> dependenciesBundleName = JoinableResourceBundlePropertySerializer.getBundleNames(dependencies);
            props.put(prefix + ".dependencies", JoinableResourceBundlePropertySerializer.getCommaSeparatedString(dependenciesBundleName));
        }
        if ((licensesPathList = bundle.getLicensesPathList()) != null && !licensesPathList.isEmpty()) {
            props.put(prefix + ".licencePathList", JoinableResourceBundlePropertySerializer.getCommaSeparatedString(licensesPathList));
        }
    }

    private static String serializeVariantSets(Map<String, VariantSet> map) {
        StringBuffer result = new StringBuffer();
        for (Map.Entry<String, VariantSet> entry : map.entrySet()) {
            result.append(entry.getKey() + ":");
            VariantSet variantSet = entry.getValue();
            result.append(variantSet.getDefaultVariant() + ":");
            result.append(JoinableResourceBundlePropertySerializer.getCommaSeparatedString(variantSet));
            result.append(";");
        }
        return result.toString();
    }

    private static List<String> getBundleNames(List<JoinableResourceBundle> bundles) {
        ArrayList<String> bundleNames = new ArrayList<String>();
        Iterator<JoinableResourceBundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            bundleNames.add(iterator.next().getName());
        }
        return bundleNames;
    }

    private static String getCommaSeparatedString(Collection<String> coll) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> eltIterator = coll.iterator();
        while (eltIterator.hasNext()) {
            String elt = eltIterator.next();
            buffer.append(elt);
            if (!eltIterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private static String getCommaSeparatedStringForBundlePath(Collection<BundlePath> coll) {
        StringBuffer buffer = new StringBuffer();
        Iterator<BundlePath> eltIterator = coll.iterator();
        while (eltIterator.hasNext()) {
            String elt = eltIterator.next().getPath();
            buffer.append(elt);
            if (!eltIterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private static String getBundlePostProcessorsName(ChainedResourceBundlePostProcessor processor) {
        String bundlePostProcessor = "";
        if (processor != null) {
            bundlePostProcessor = processor.getId();
        }
        return bundlePostProcessor;
    }
}

