/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.jawr.web.resource.bundle.DebugInclusion;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.bundle.factory.postprocessor.PostProcessorChainFactory;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;

public class FullMappingPropertiesBasedBundlesHandlerFactory {
    private PostProcessorChainFactory chainFactory;
    private String resourceType;
    private ResourceReaderHandler rsReaderHandler;
    private GeneratorRegistry generatorRegistry;

    public FullMappingPropertiesBasedBundlesHandlerFactory(String resourceType, ResourceReaderHandler rsHandler, GeneratorRegistry generatorRegistry, PostProcessorChainFactory chainFactory) {
        this.resourceType = resourceType;
        this.chainFactory = chainFactory;
        this.rsReaderHandler = rsHandler;
        this.generatorRegistry = generatorRegistry;
    }

    public List<JoinableResourceBundle> getResourceBundles(Properties properties) {
        PropertiesConfigHelper props = new PropertiesConfigHelper(properties, this.resourceType);
        String fileExtension = "." + this.resourceType;
        ArrayList<JoinableResourceBundle> customBundles = new ArrayList<JoinableResourceBundle>();
        if (null != props.getProperty("bundle.names")) {
            StringTokenizer tk = new StringTokenizer(props.getProperty("bundle.names"), ",");
            while (tk.hasMoreTokens()) {
                customBundles.add(this.buildJoinableResourceBundle(props, tk.nextToken().trim(), fileExtension, this.rsReaderHandler));
            }
        } else {
            Iterator<String> bundleNames = props.getPropertyBundleNameSet().iterator();
            while (bundleNames.hasNext()) {
                customBundles.add(this.buildJoinableResourceBundle(props, bundleNames.next(), fileExtension, this.rsReaderHandler));
            }
        }
        for (String bundleName : props.getPropertyBundleNameSet()) {
            List<String> bundleNameDependencies = props.getCustomBundlePropertyAsList(bundleName, ".dependencies");
            if (bundleNameDependencies.isEmpty()) continue;
            JoinableResourceBundle bundle = this.getBundleFromName(bundleName, customBundles);
            List<JoinableResourceBundle> bundleDependencies = this.getBundlesFromName(bundleNameDependencies, customBundles);
            bundle.setDependencies(bundleDependencies);
        }
        return customBundles;
    }

    private JoinableResourceBundle getBundleFromName(String bundleName, List<JoinableResourceBundle> bundles) {
        JoinableResourceBundle bundle = null;
        ArrayList<String> names = new ArrayList<String>();
        names.add(bundleName);
        List<JoinableResourceBundle> result = this.getBundlesFromName(names, bundles);
        if (!result.isEmpty()) {
            bundle = result.get(0);
        }
        return bundle;
    }

    private List<JoinableResourceBundle> getBundlesFromName(List<String> names, List<JoinableResourceBundle> bundles) {
        ArrayList<JoinableResourceBundle> resultBundles = new ArrayList<JoinableResourceBundle>();
        for (String name : names) {
            for (JoinableResourceBundle bundle : bundles) {
                if (!bundle.getName().equals(name)) continue;
                resultBundles.add(bundle);
            }
        }
        return resultBundles;
    }

    private JoinableResourceBundle buildJoinableResourceBundle(PropertiesConfigHelper props, String bundleName, String fileExtension, ResourceReaderHandler rsHandler) {
        List<String> mappings;
        Set<String> licencePathList;
        String alternateProductionURL;
        String explorerConditionalCondition;
        String unitaryPostProcessors;
        String bundleId = props.getCustomBundleProperty(bundleName, ".id");
        String bundlePrefix = props.getCustomBundleProperty(bundleName, ".bundle.prefix");
        InclusionPattern inclusionPattern = this.getInclusionPattern(props, bundleName);
        JoinableResourceBundleImpl bundle = new JoinableResourceBundleImpl(bundleId, bundleName, bundlePrefix, fileExtension, inclusionPattern, rsHandler, this.generatorRegistry);
        String bundlePostProcessors = props.getCustomBundleProperty(bundleName, ".bundlepostprocessors");
        if (StringUtils.isNotEmpty(bundlePostProcessors)) {
            bundle.setBundlePostProcessor(this.chainFactory.buildPostProcessorChain(bundlePostProcessors));
        }
        if (StringUtils.isNotEmpty(unitaryPostProcessors = props.getCustomBundleProperty(bundleName, ".filepostprocessors"))) {
            bundle.setUnitaryPostProcessor(this.chainFactory.buildPostProcessorChain(unitaryPostProcessors));
        }
        if (StringUtils.isNotEmpty(explorerConditionalCondition = props.getCustomBundleProperty(bundleName, ".ieonly.condition"))) {
            bundle.setExplorerConditionalExpression(explorerConditionalCondition);
        }
        if (StringUtils.isNotEmpty(alternateProductionURL = props.getCustomBundleProperty(bundleName, ".productionURL"))) {
            bundle.setAlternateProductionURL(props.getCustomBundleProperty(bundleName, ".productionURL"));
        }
        if (!(licencePathList = props.getCustomBundlePropertyAsSet(bundleName, ".licencePathList")).isEmpty()) {
            bundle.setLicensesPathList(licencePathList);
        }
        if ((mappings = props.getCustomBundlePropertyAsList(bundleName, ".mappings")).isEmpty()) {
            throw new IllegalArgumentException("No mappings were defined for the bundle with name:" + bundleName + ". Please specify at least one in configuration. ");
        }
        bundle.setMappings(mappings);
        Map<String, VariantSet> variants = props.getCustomBundleVariantSets(bundleName);
        bundle.setVariants(variants);
        for (String variantKey : bundle.getVariantKeys()) {
            if (!StringUtils.isNotEmpty(variantKey)) continue;
            String hashcode = props.getCustomBundleProperty(bundleName, ".bundleHashcode." + variantKey);
            bundle.setBundleDataHashCode(variantKey, hashcode);
        }
        String hashcode = props.getCustomBundleProperty(bundleName, ".bundleHashcode");
        bundle.setBundleDataHashCode(null, hashcode);
        return bundle;
    }

    private InclusionPattern getInclusionPattern(PropertiesConfigHelper props, String bundleName) {
        boolean isGlobal = Boolean.valueOf(props.getCustomBundleProperty(bundleName, ".global", "false"));
        int order = 0;
        if (isGlobal) {
            order = Integer.parseInt(props.getCustomBundleProperty(bundleName, ".order", "0"));
        }
        boolean isDebugOnly = Boolean.valueOf(props.getCustomBundleProperty(bundleName, ".debugonly", "false"));
        boolean isDebugNever = Boolean.valueOf(props.getCustomBundleProperty(bundleName, ".debugnever", "false"));
        return new InclusionPattern(isGlobal, order, DebugInclusion.get(isDebugOnly, isDebugNever));
    }
}

