/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.jawr.web.exception.DuplicateBundlePathException;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceOrphanBundleImpl;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class OrphanResourceBundlesMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrphanResourceBundlesMapper.class);
    protected String baseDir = "/**";
    protected ResourceReaderHandler rsHandler;
    protected GeneratorRegistry generatorRegistry;
    protected List<JoinableResourceBundle> currentBundles;
    protected String resourceExtension;
    private List<String> bundleMapping;

    public OrphanResourceBundlesMapper(String baseDir, ResourceReaderHandler rsHandler, GeneratorRegistry generatorRegistry, List<JoinableResourceBundle> currentBundles, String resourceExtension) {
        if (!"".equals(baseDir)) {
            if (generatorRegistry.isPathGenerated(baseDir)) {
                this.baseDir = PathNormalizer.normalizePath(baseDir) + "/**";
            } else if (!"/".equals(baseDir)) {
                this.baseDir = "/" + PathNormalizer.normalizePath(baseDir) + "/**";
            }
        }
        this.rsHandler = rsHandler;
        this.generatorRegistry = generatorRegistry;
        this.currentBundles = new ArrayList<JoinableResourceBundle>();
        if (null != currentBundles) {
            this.currentBundles.addAll(currentBundles);
        }
        this.resourceExtension = resourceExtension;
        this.bundleMapping = new ArrayList<String>();
    }

    public List<String> getOrphansList() throws DuplicateBundlePathException {
        JoinableResourceOrphanBundleImpl tempBundle = new JoinableResourceOrphanBundleImpl("orphansTemp", "orphansTemp", this.resourceExtension, new InclusionPattern(), Collections.singletonList(this.baseDir), this.rsHandler, this.generatorRegistry);
        Set<String> licensesPathList = tempBundle.getLicensesPathList();
        Iterator<String> it = licensesPathList.iterator();
        while (it.hasNext()) {
            this.addFileIfNotMapped(it.next());
        }
        List<BundlePath> allPaths = tempBundle.getItemPathList();
        Iterator<BundlePath> it2 = allPaths.iterator();
        while (it2.hasNext()) {
            this.addFileIfNotMapped(it2.next().getPath());
        }
        return this.bundleMapping;
    }

    private void addFileIfNotMapped(String filePath) throws DuplicateBundlePathException {
        for (JoinableResourceBundle bundle : this.currentBundles) {
            List<BundlePath> items = bundle.getItemPathList();
            List<BundlePath> itemsDebug = bundle.getItemDebugPathList();
            Set<String> licenses = bundle.getLicensesPathList();
            for (BundlePath path : items) {
                if (!path.getPath().equals(filePath)) continue;
                return;
            }
            for (BundlePath path : itemsDebug) {
                if (!path.getPath().equals(filePath)) continue;
                return;
            }
            if (licenses.contains(filePath)) {
                return;
            }
            if (!filePath.equals(bundle.getId())) continue;
            Marker fatal = MarkerFactory.getMarker((String)"FATAL");
            LOGGER.error(fatal, "Duplicate bundle id resulted from orphan mapping of:" + filePath);
            throw new DuplicateBundlePathException(filePath);
        }
        if (!filePath.startsWith("/WEB-INF/") && !filePath.startsWith("/META-INF/")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding orphan resource: " + filePath);
            }
            this.bundleMapping.add(filePath);
        }
    }
}

