/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.mapper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jawr.web.exception.DuplicateBundlePathException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.mapper.AbstractResourceMapper;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleDirMapper
extends AbstractResourceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleDirMapper.class);
    private Set<String> excludedPaths;

    public ResourceBundleDirMapper(String baseDir, ResourceReaderHandler rsHandler, List<JoinableResourceBundle> currentBundles, String resourceExtension, Set<String> excludedPaths) {
        super(baseDir, rsHandler, currentBundles, resourceExtension);
        this.excludedPaths = this.initExcludedPathList(excludedPaths);
    }

    private Set<String> initExcludedPathList(Set<String> paths) {
        HashSet<String> toExclude = new HashSet<String>();
        if (null == paths) {
            return toExclude;
        }
        for (String path : paths) {
            path = PathNormalizer.asPath(path);
            toExclude.add(path);
        }
        return toExclude;
    }

    @Override
    protected void addBundlesToMapping() throws DuplicateBundlePathException {
        Set<String> paths = this.rsHandler.getResourceNames(this.baseDir);
        for (String path : paths) {
            if (this.excludedPaths.contains(path = PathNormalizer.joinPaths(this.baseDir, path)) || !this.rsHandler.isDirectory(path)) continue;
            String bundleKey = path + this.resourceExtension;
            this.addBundleToMap(bundleKey, path + "/**");
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Added [" + bundleKey + "] with value [" + path + "/**] to a generated path list");
        }
    }
}

