/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPropertiesAugmenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPropertiesAugmenter.class);
    private final Properties configProperties;
    private Set<String> privateConfigProperties;

    public ConfigPropertiesAugmenter(Properties configProperties, Set<String> privateConfigProperties) {
        this.configProperties = configProperties;
        this.privateConfigProperties = privateConfigProperties;
    }

    public ConfigPropertiesAugmenter(Properties configProperties) {
        this.configProperties = configProperties;
    }

    public void augmentConfiguration(Properties configToAdd) {
        for (Map.Entry<Object, Object> entry : configToAdd.entrySet()) {
            String configKey = (String)entry.getKey();
            String configValue = (String)entry.getValue();
            if (null != this.privateConfigProperties && this.privateConfigProperties.contains(configKey)) {
                LOGGER.warn("The property " + configKey + " can not be overriden. It will remain with a value of " + this.configProperties.get(configKey));
                continue;
            }
            if (this.isAugmentable(configKey)) {
                String currentValue = this.configProperties.getProperty(configKey);
                currentValue = currentValue + "," + configValue;
                this.configProperties.put(configKey, currentValue);
                continue;
            }
            this.configProperties.put(configKey, configValue);
        }
    }

    protected boolean isAugmentable(String configKey) {
        boolean rets = false;
        rets = configKey.endsWith("bundle.names") || configKey.endsWith(".mappings") || configKey.endsWith(".child.names") || configKey.equals("jawr.custom.postprocessors.names") || configKey.equals("jawr.custom.generators");
        rets = rets && this.configProperties.containsKey(configKey);
        return rets;
    }
}

