/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.exception.JawrLinkRenderingException;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathNormalizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathNormalizer.class);
    private static final Pattern URL_SEPARATOR_PATTERN = Pattern.compile("([^/]*)/");
    private static final String ROOT_REPLACE_PATTERN = "../";

    private PathNormalizer() {
    }

    public static String escapeToPhysicalPath(String bundlePath) {
        return bundlePath.replaceAll(":", "_");
    }

    public static String removeVariantPrefixFromPath(String path) {
        String prefix;
        String resultPath = path;
        if (path.charAt(0) == '/') {
            resultPath = path.substring(1);
        }
        if ((prefix = resultPath.substring(0, resultPath.indexOf("/"))).indexOf(46) != -1) {
            String variantPrefix = prefix.substring(prefix.indexOf(46) + 1);
            String suffix = '@' + variantPrefix + resultPath.substring(resultPath.lastIndexOf(46));
            resultPath = resultPath.substring(resultPath.indexOf("/"), resultPath.lastIndexOf(46)) + suffix;
        } else {
            resultPath = resultPath.substring(resultPath.indexOf("/"));
        }
        return resultPath;
    }

    public static String[] extractBundleInfoFromPath(String path) {
        String[] result = new String[4];
        String bundlePrefix = null;
        String resultPath = null;
        try {
            int idxGzip = path.indexOf("/gzip_");
            if (idxGzip != -1) {
                if (idxGzip != 0) {
                    bundlePrefix = PathNormalizer.asDirPath(path.substring(1, idxGzip));
                }
                resultPath = path.substring(idxGzip + "/gzip_".length());
            } else {
                resultPath = path.substring(1);
            }
            int realPathStartIdx = resultPath.indexOf("/");
            String prefix = "";
            if (realPathStartIdx != -1) {
                prefix = resultPath.substring(0, realPathStartIdx);
            }
            String hashcode = null;
            String variantPrefix = null;
            int hashCodeVariantSeparatorIdx = prefix.indexOf(46);
            if (hashCodeVariantSeparatorIdx != -1) {
                hashcode = prefix.substring(0, hashCodeVariantSeparatorIdx);
                variantPrefix = prefix.substring(hashCodeVariantSeparatorIdx + 1);
                resultPath = resultPath.substring(realPathStartIdx);
            } else {
                hashcode = prefix.substring(0, realPathStartIdx);
                resultPath = resultPath.substring(realPathStartIdx);
            }
            if (resultPath.startsWith("/") && resultPath.contains(":")) {
                resultPath = resultPath.substring(1);
            }
            result[0] = bundlePrefix;
            result[1] = resultPath;
            result[2] = variantPrefix;
            result[3] = hashcode;
        }
        catch (Exception e) {
            LOGGER.debug("Unable to extract bundle info for path : " + path);
            result = null;
        }
        return result;
    }

    public static String normalizePathMapping(String pathMapping) {
        String normalizedPathMapping = PathNormalizer.normalizePath(pathMapping);
        if (normalizedPathMapping.endsWith("/**")) {
            normalizedPathMapping = normalizedPathMapping.substring(0, normalizedPathMapping.length() - 3);
        }
        return normalizedPathMapping;
    }

    public static String asPath(String path) {
        return "/" + PathNormalizer.normalizePath(path);
    }

    public static String asDirPath(String path) {
        String dirPath = path;
        if (!path.equals("/")) {
            dirPath = "/" + PathNormalizer.normalizePath(path) + "/";
        }
        return dirPath;
    }

    public static String joinPaths(String prefix, String path, GeneratorRegistry generatorRegistry) {
        return PathNormalizer.joinPaths(prefix, path, generatorRegistry.isPathGenerated(prefix));
    }

    public static String joinPaths(String prefix, String path, boolean generatedPath) {
        String result = null;
        result = generatedPath ? PathNormalizer.joinDomainToPath(prefix, path) : PathNormalizer.joinPaths(prefix, path);
        return result;
    }

    public static String joinPaths(String prefix, String path) {
        String joinedPath = null;
        if (prefix.startsWith("http://") || prefix.startsWith("https://") || prefix.startsWith("//")) {
            joinedPath = PathNormalizer.joinDomainToPath(prefix, path);
        } else {
            String normalizedPrefix = PathNormalizer.normalizePath(prefix);
            StringBuffer sb = new StringBuffer("/");
            if (!"".equals(normalizedPrefix)) {
                sb.append(normalizedPrefix).append("/");
            }
            sb.append(PathNormalizer.normalizePath(path));
            joinedPath = sb.toString();
        }
        return joinedPath;
    }

    public static String joinDomainToPath(String domainName, String path) {
        StringBuffer sb = new StringBuffer();
        if (domainName.endsWith("/")) {
            sb.append(domainName.substring(0, domainName.length() - 1));
        } else {
            sb.append(domainName);
        }
        sb.append("/").append(PathNormalizer.normalizePath(path));
        return sb.toString();
    }

    public static final String normalizePath(String path) {
        String normalizedPath = path.replaceAll("//", "/");
        StringTokenizer tk = new StringTokenizer(normalizedPath, "/");
        StringBuffer sb = new StringBuffer();
        while (tk.hasMoreTokens()) {
            sb.append(tk.nextToken());
            if (!tk.hasMoreTokens()) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public static final Set<String> normalizePaths(Set<String> paths) {
        HashSet<String> ret = new HashSet<String>();
        Iterator<String> it = paths.iterator();
        while (it.hasNext()) {
            String path = PathNormalizer.normalizePath(it.next());
            ret.add(path);
        }
        return ret;
    }

    public static String createGenerationPath(String path, GeneratorRegistry registry, String randomParam) {
        String requestPath = null;
        try {
            requestPath = registry.getDebugModeGenerationPath(path);
            requestPath = randomParam != null ? requestPath + "?" + randomParam + "&" : requestPath + "?";
            requestPath = requestPath + "generationConfigParam=" + URLEncoder.encode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException neverHappens) {
            throw new JawrLinkRenderingException("Something went unexpectedly wrong while encoding a URL for a generator. ", neverHappens);
        }
        return requestPath;
    }

    public static String addGetParameter(String path, String parameterKey, String parameter) {
        StringBuffer sb = new StringBuffer(path);
        if (path.indexOf("?") > 0) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(parameterKey + "=" + parameter);
        return sb.toString();
    }

    public static String getParentPath(String path) {
        String parentPath = null;
        if (StringUtils.isEmpty(path)) {
            parentPath = "";
        } else {
            int index;
            parentPath = path;
            if (parentPath.length() > 1 && parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 2);
            }
            if ((index = parentPath.lastIndexOf("/")) > 0) {
                return parentPath.substring(0, index + 1);
            }
            parentPath = "/";
        }
        return parentPath;
    }

    public static String getPathName(String path) {
        String pathName = null;
        if (StringUtils.isEmpty(path)) {
            pathName = "";
        } else {
            int index;
            pathName = path;
            if (pathName.length() > 1 && pathName.endsWith("/")) {
                pathName = pathName.substring(0, pathName.length() - 1);
            }
            pathName = (index = pathName.lastIndexOf("/")) > 0 ? pathName.substring(index + 1) : "/";
        }
        return pathName;
    }

    public static final String getRelativePath(String basedir, String filename) {
        String basedirPath = PathNormalizer.uppercaseDrive(basedir);
        String filenamePath = PathNormalizer.uppercaseDrive(filename);
        if (basedirPath == null || basedirPath.length() == 0 || filenamePath == null || filenamePath.length() == 0 || !filenamePath.startsWith(basedirPath)) {
            return "";
        }
        String separator = PathNormalizer.determineSeparator(filenamePath);
        basedirPath = StringUtils.chompLast(basedirPath, separator);
        filenamePath = StringUtils.chompLast(filenamePath, separator);
        String relativeFilename = filenamePath.substring(basedirPath.length());
        return PathNormalizer.determineRelativePath(relativeFilename, separator);
    }

    public static String concatWebPath(String basePath, String fullFilenameToAdd) {
        if (fullFilenameToAdd == null || basePath == null && (fullFilenameToAdd.length() == 0 || fullFilenameToAdd.charAt(0) != '/')) {
            return null;
        }
        if (basePath == null) {
            basePath = "";
        }
        if (basePath.length() > 1 && basePath.charAt(basePath.length() - 1) != '/') {
            basePath = PathNormalizer.getParentPath(basePath);
        }
        int len = basePath.length();
        String fullPath = null;
        if (len == 0) {
            return PathNormalizer.doNormalizeIgnoreOtherSeparator(fullFilenameToAdd, true);
        }
        char ch = basePath.charAt(len - 1);
        fullPath = ch == '/' ? basePath + fullFilenameToAdd : basePath + '/' + fullFilenameToAdd;
        return PathNormalizer.doNormalizeIgnoreOtherSeparator(fullPath, true);
    }

    private static String doNormalizeIgnoreOtherSeparator(String filename, boolean keepSeparator) {
        int i;
        if (filename == null) {
            return null;
        }
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = 0;
        char[] array = new char[size + 2];
        filename.getChars(0, filename.length(), array, 0);
        boolean lastIsDirectory = true;
        if (array[size - 1] != '/') {
            array[size++] = 47;
            lastIsDirectory = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != '/' || array[i - 1] != '/') continue;
            System.arraycopy(array, i, array, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != '/' || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != '/') continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block2: for (i = prefix + 2; i < size; ++i) {
            if (array[i] != '/' || array[i - 1] != '.' || array[i - 2] != '.' || i != prefix + 2 && array[i - 3] != '/') continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != '/') continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block2;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    public static final String getRelativeWebPath(String oldPath, String newPath) {
        if (StringUtils.isEmpty(oldPath) || StringUtils.isEmpty(newPath)) {
            return "";
        }
        String resultPath = PathNormalizer.buildRelativePath(newPath, oldPath, '/');
        if (newPath.endsWith("/") && !resultPath.endsWith("/")) {
            return resultPath + "/";
        }
        return resultPath;
    }

    public static final String getRelativeFilePath(String oldPath, String newPath) {
        if (StringUtils.isEmpty(oldPath) || StringUtils.isEmpty(newPath)) {
            return "";
        }
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String resultPath = PathNormalizer.buildRelativePath(toPath, fromPath, File.separatorChar);
        if (newPath.endsWith(File.separator) && !resultPath.endsWith(File.separator)) {
            return resultPath + File.separator;
        }
        return resultPath;
    }

    private static final String determineRelativePath(String filename, String separator) {
        if (filename.length() == 0) {
            return "";
        }
        int slashCount = StringUtils.countMatches(filename, separator) - 1;
        if (slashCount <= 0) {
            return ".";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < slashCount; ++i) {
            sb.append(ROOT_REPLACE_PATTERN);
        }
        return StringUtils.chop(sb.toString());
    }

    private static final String determineSeparator(String filename) {
        int backwardCount;
        int forwardCount = StringUtils.countMatches(filename, "/");
        return forwardCount >= (backwardCount = StringUtils.countMatches(filename, "\\")) ? "/" : "\\";
    }

    static final String uppercaseDrive(String path) {
        String resultPath = null;
        if (path != null) {
            resultPath = path.length() >= 2 && path.charAt(1) == ':' ? Character.toUpperCase(path.charAt(0)) + path.substring(1) : path;
        }
        return resultPath;
    }

    private static final String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        StringBuffer relativePath = new StringBuffer();
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath.append("..");
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath.append(separatorChar);
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath.append(toTokeniser.nextToken());
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        return relativePath.toString();
    }

    public static String getRootRelativePath(String url) {
        Matcher matcher = URL_SEPARATOR_PATTERN.matcher(url);
        StringBuffer result = new StringBuffer();
        boolean first = true;
        while (matcher.find()) {
            if (first) {
                matcher.appendReplacement(result, "");
                first = false;
                continue;
            }
            matcher.appendReplacement(result, ROOT_REPLACE_PATTERN);
        }
        return result.toString();
    }
}

