/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.css.CssImageUrlRewriter;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.CssResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.SpecificCDNDebugPathResourceGenerator;

public abstract class AbstractCSSGenerator
implements SpecificCDNDebugPathResourceGenerator,
CssResourceGenerator {
    @Override
    public String getDebugModeRequestPath() {
        return "/jawr_generator.css";
    }

    @Override
    public String getDebugModeBuildTimeGenerationPath(String path) {
        return path.replaceFirst(":", "/");
    }

    @Override
    public Reader createResource(GeneratorContext context) {
        Reader rd = null;
        rd = context.isProcessingBundle() ? this.generateResourceForBundle(context) : this.generateResourceForDebug(context);
        return rd;
    }

    protected abstract Reader generateResourceForBundle(GeneratorContext var1);

    protected Reader generateResourceForDebug(GeneratorContext context) {
        Reader rd = this.generateResourceForBundle(context);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy(rd, (Writer)writer);
            JawrConfig jawrConfig = context.getConfig();
            CssImageUrlRewriter rewriter = new CssImageUrlRewriter(jawrConfig);
            String bundlePath = PathNormalizer.joinPaths(jawrConfig.getServletMapping(), "/jawr_generator.css");
            StringBuffer result = rewriter.rewriteUrl(context.getPath(), bundlePath, writer.toString());
            rd = new StringReader(result.toString());
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        return rd;
    }

    @Override
    public boolean isHandlingCssImage() {
        return false;
    }
}

