/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.LocaleAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.TextResourceGenerator;
import net.jawr.web.resource.bundle.generator.variant.VariantResourceGenerator;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.handler.reader.TextResourceReader;

public class ResourceGeneratorReaderWrapper
implements TextResourceReader {
    private TextResourceGenerator generator;
    private ResourceReaderHandler rsHandler;
    private JawrConfig config;

    public ResourceGeneratorReaderWrapper(TextResourceGenerator generator, ResourceReaderHandler rsHandler, JawrConfig config) {
        this.generator = generator;
        this.config = config;
        this.rsHandler = rsHandler;
    }

    @Override
    public Reader getResource(String resourceName) {
        return this.getResource(resourceName, false);
    }

    @Override
    public Reader getResource(String resourceName, boolean processingBundle) {
        int variantSuffixIdx;
        Locale locale = null;
        String path = this.generator.getResolver().getResourcePath(resourceName);
        HashMap<String, String> contextVariants = new HashMap<String, String>();
        Map<String, VariantSet> variantSets = new HashMap<String, VariantSet>();
        if ((this.generator instanceof VariantResourceGenerator || this.generator instanceof LocaleAwareResourceGenerator) && (variantSuffixIdx = path.indexOf("@")) != -1) {
            String variantKey = path.substring(path.indexOf(64) + 1);
            path = path.substring(0, variantSuffixIdx);
            String[] variants = variantKey.split("@");
            if (this.generator instanceof VariantResourceGenerator) {
                variantSets = ((VariantResourceGenerator)((Object)this.generator)).getAvailableVariants(path);
            } else {
                List<String> availableLocales = ((LocaleAwareResourceGenerator)((Object)this.generator)).getAvailableLocales(path);
                if (availableLocales != null) {
                    variantSets.put("locale", new VariantSet("locale", "", availableLocales));
                }
            }
            ArrayList<String> variantTypes = new ArrayList<String>(variantSets.keySet());
            Collections.sort(variantTypes);
            int nbVariants = variants.length;
            block4: for (int i = 0; i < nbVariants; ++i) {
                String variantType = (String)variantTypes.get(i);
                String variantValue = variants[i];
                contextVariants.put(variantType, variantValue);
                if (variantType != "locale") continue;
                String[] params = variantValue.split("_");
                switch (params.length) {
                    case 3: {
                        locale = new Locale(params[0], params[1], params[2]);
                        continue block4;
                    }
                    case 2: {
                        locale = new Locale(params[0], params[1]);
                        continue block4;
                    }
                    default: {
                        locale = new Locale(variantValue);
                    }
                }
            }
        }
        GeneratorContext context = new GeneratorContext(this.config, path);
        context.setVariantMap(contextVariants);
        context.setVariantSets(variantSets);
        context.setLocale(locale);
        context.setResourceReaderHandler(this.rsHandler);
        context.setProcessingBundle(processingBundle);
        return this.generator.createResource(context);
    }
}

