/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.classpath;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorContext;

public class ClassPathGeneratorHelper {
    private final String prefix;

    public ClassPathGeneratorHelper() {
        this("");
    }

    public ClassPathGeneratorHelper(String prefix) {
        this.prefix = prefix;
    }

    public Reader createResource(GeneratorContext context) {
        InputStream is = this.createStreamResource(context);
        ReadableByteChannel chan = Channels.newChannel(is);
        return Channels.newReader(chan, context.getCharset().newDecoder(), -1);
    }

    public InputStream createStreamResource(GeneratorContext context) {
        try {
            String path = PathNormalizer.normalizePath(this.prefix + context.getPath());
            return ClassLoaderResourceUtils.getResourceAsStream(path, this);
        }
        catch (FileNotFoundException e) {
            throw new BundlingProcessException(e);
        }
    }
}

