/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.less;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import com.asual.lesscss.loader.ChainedResourceLoader;
import com.asual.lesscss.loader.CssProcessingResourceLoader;
import com.asual.lesscss.loader.ResourceLoader;
import com.asual.lesscss.loader.UnixNewlinesResourceLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.ConfigurationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.PostInitializationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.ResourceReaderHandlerAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.less.ILessCssResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.less.JawrResourceLoader;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;

public class LessCssGenerator
extends AbstractCSSGenerator
implements ILessCssResourceGenerator,
ConfigurationAwareResourceGenerator,
ResourceReaderHandlerAwareResourceGenerator,
PostInitializationAwareResourceGenerator {
    private static final String LESS_SCRIPT_LOCATION_PROPERTY_NAME = "jawr.css.less.generator.less.script.location";
    private static final String LESS_RESOURCE_LOADER_PROPERTY_NAME = "jawr.css.less.generator.resource.loader.class";
    private static final String LESS_SUFFIX = "less";
    private ResourceGeneratorResolver resolver;
    private ResourceReaderHandler rsHandler;
    private LessEngine engine;
    private JawrConfig config;
    private LessOptions options = new LessOptions();

    public LessCssGenerator() {
        this.resolver = ResourceGeneratorResolverFactory.createSuffixResolver(LESS_SUFFIX);
    }

    @Override
    public void setConfig(JawrConfig config) {
        this.config = config;
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public void setResourceReaderHandler(ResourceReaderHandler rsHandler) {
        this.rsHandler = rsHandler;
    }

    @Override
    public void afterPropertiesSet() {
        URL lessURL;
        String lessScript = this.config.getProperty(LESS_SCRIPT_LOCATION_PROPERTY_NAME);
        if (lessScript != null && (lessURL = this.getResourceURL(lessScript)) != null) {
            this.options.setLess(lessURL);
        }
        this.engine = new LessEngine(this.options, this.buildResourceLoader(this.options, this.rsHandler));
    }

    private ResourceLoader buildResourceLoader(LessOptions options, ResourceReaderHandler rsReaderHandler) {
        String resourceLoaderClass = this.config.getProperty(LESS_RESOURCE_LOADER_PROPERTY_NAME);
        JawrResourceLoader resourceLoader = null;
        if (StringUtils.isNotEmpty(resourceLoaderClass)) {
            ResourceLoader customResourceLoader = (ResourceLoader)ClassLoaderResourceUtils.buildObjectInstance(resourceLoaderClass);
            resourceLoader = new ChainedResourceLoader(new ResourceLoader[]{new JawrResourceLoader(rsReaderHandler), customResourceLoader});
        } else {
            resourceLoader = new JawrResourceLoader(rsReaderHandler);
        }
        if (options.isCss()) {
            return new CssProcessingResourceLoader((ResourceLoader)resourceLoader);
        }
        resourceLoader = new UnixNewlinesResourceLoader((ResourceLoader)resourceLoader);
        return resourceLoader;
    }

    public URL getResourceURL(String path) {
        URL url = null;
        try {
            url = this.config.getContext().getResource(path);
            if (url == null) {
                url = ClassLoaderResourceUtils.getResourceURL(path, this);
            }
        }
        catch (MalformedURLException e) {
            throw new BundlingProcessException(e);
        }
        catch (ResourceNotFoundException e1) {
            throw new BundlingProcessException(e1);
        }
        return url;
    }

    @Override
    protected Reader generateResourceForBundle(GeneratorContext context) {
        String path = context.getPath();
        Reader rd = null;
        try {
            ArrayList excluded = new ArrayList();
            excluded.add(ILessCssResourceGenerator.class);
            rd = context.getResourceReaderHandler().getResource(path, false, excluded);
            if (rd == null) {
                throw new ResourceNotFoundException(path);
            }
            StringWriter swr = new StringWriter();
            IOUtils.copy(rd, (Writer)swr);
            String result = this.compile(swr.toString(), path);
            rd = new StringReader(result);
        }
        catch (ResourceNotFoundException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
        return rd;
    }

    public String compile(String content, String path) {
        try {
            return this.engine.compile(content, path);
        }
        catch (LessException e) {
            throw new RuntimeException("Problem compiling Less CSS from Resource '" + path + "'", e);
        }
    }
}

