/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.js.coffee;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.AbstractJavascriptGenerator;
import net.jawr.web.resource.bundle.generator.ConfigurationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.PostInitializationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.js.coffee.ICoffeeScriptGenerator;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.util.js.RhinoEngine;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class CoffeeScriptGenerator
extends AbstractJavascriptGenerator
implements ConfigurationAwareResourceGenerator,
PostInitializationAwareResourceGenerator,
ICoffeeScriptGenerator {
    private static final String COFFEE_SCRIPT_SUFFIX = "coffee";
    private static final String JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS = "jawr.js.generator.coffee.script.options";
    private static final String JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION = "jawr.js.generator.coffee.script.location";
    private static final String DEFAULT_COFFEE_SCRIPT_JS_LOCATION = "net/jawr/web/resource/bundle/generator/js/coffee/coffee-script.js";
    private ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createSuffixResolver("coffee");
    private JawrConfig config;
    private String options;
    private RhinoEngine rhino;

    @Override
    public void setConfig(JawrConfig config) {
        this.config = config;
    }

    @Override
    public void afterPropertiesSet() {
        this.options = this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS, "");
        String script = this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION, DEFAULT_COFFEE_SCRIPT_JS_LOCATION);
        this.rhino = new RhinoEngine();
        InputStream inputStream = this.getResourceInputStream(script);
        this.rhino.evaluate("coffee-script.js", inputStream);
    }

    private InputStream getResourceInputStream(String path) {
        InputStream is = this.config.getContext().getResourceAsStream(path);
        if (is == null) {
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException(e);
            }
        }
        return is;
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public Reader createResource(GeneratorContext context) {
        String path = context.getPath();
        Reader rd = null;
        try {
            ArrayList excluded = new ArrayList();
            excluded.add(ICoffeeScriptGenerator.class);
            rd = context.getResourceReaderHandler().getResource(path, false, excluded);
            StringWriter swr = new StringWriter();
            IOUtils.copy(rd, (Writer)swr);
            String result = this.compile(swr.toString());
            rd = new StringReader(result);
        }
        catch (ResourceNotFoundException e) {
            throw new BundlingProcessException(e);
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        return rd;
    }

    public String compile(String coffeeScriptSource) {
        Scriptable compileScope = this.rhino.newObject();
        compileScope.put("coffeeScriptSource", compileScope, (Object)coffeeScriptSource);
        try {
            return (String)this.rhino.evaluateString(compileScope, String.format("CoffeeScript.compile(coffeeScriptSource, '%s');", this.options), "JCoffeeScriptCompiler");
        }
        catch (JavaScriptException e) {
            throw new BundlingProcessException(e);
        }
    }
}

