/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.resolver;

import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.util.StringUtils;

public class SuffixedPathResolver
implements ResourceGeneratorResolver {
    public static final String SUFFIX_SEPARATOR = ".";
    private String suffix;
    private boolean skipSuffix;

    public SuffixedPathResolver(String suffix) {
        this(suffix, SUFFIX_SEPARATOR, false);
    }

    public SuffixedPathResolver(String suffix, String separator) {
        this(suffix, separator, false);
    }

    public SuffixedPathResolver(String suffix, String separator, boolean skipSuffix) {
        this.suffix = separator + suffix;
        this.skipSuffix = skipSuffix;
    }

    @Override
    public boolean matchPath(String path) {
        boolean match = false;
        if (StringUtils.isNotEmpty(path)) {
            match = path.endsWith(this.suffix);
        }
        return match;
    }

    @Override
    public boolean isSameAs(ResourceGeneratorResolver matcher) {
        return this.equals(matcher);
    }

    @Override
    public String getResourcePath(String requestedPath) {
        String resourcePath = requestedPath;
        if (this.skipSuffix) {
            resourcePath = requestedPath.substring(0, requestedPath.length() - this.suffix.length());
        }
        return resourcePath;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuffixedPathResolver)) {
            return false;
        }
        SuffixedPathResolver other = (SuffixedPathResolver)obj;
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }
}

