/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.variant.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.css.CssImageUrlRewriter;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.ConfigurationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.PostInitializationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.ResourceReaderHandlerAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.StreamResourceGenerator;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.generator.variant.VariantResourceGenerator;
import net.jawr.web.resource.bundle.generator.variant.css.AbstractCssSkinVariantResolver;
import net.jawr.web.resource.bundle.generator.variant.css.CssSkinVariantResolver;
import net.jawr.web.resource.bundle.generator.variant.css.CssSkinVariantResourceProviderStrategy;
import net.jawr.web.resource.bundle.locale.LocaleUtils;
import net.jawr.web.resource.bundle.variant.VariantResourceReaderStrategy;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.handler.reader.ResourceBrowser;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;

public class CssSkinGenerator
extends AbstractCSSGenerator
implements VariantResourceGenerator,
ResourceBrowser,
StreamResourceGenerator,
ConfigurationAwareResourceGenerator,
ResourceReaderHandlerAwareResourceGenerator,
PostInitializationAwareResourceGenerator {
    private ResourceBrowser rsBrowser;
    private ResourceGeneratorResolver resolver;
    private AbstractCssSkinVariantResolver cssSkinResolver;
    private JawrConfig config;
    private CssImageUrlRewriter urlRewriter;
    private String skinMappingType = "skin_locale";
    private Map<String, Map<String, VariantSet>> skinMapping = new HashMap<String, Map<String, VariantSet>>();
    private Class<?> resourceProviderStrategyClass;

    public CssSkinGenerator() {
        this.resolver = ResourceGeneratorResolverFactory.createPrefixResolver("skin");
    }

    public CssSkinGenerator(ResourceBrowser rsBrowser, JawrConfig config) {
        this(rsBrowser, config, true);
    }

    public CssSkinGenerator(ResourceBrowser rsBrowser, JawrConfig config, boolean initSkinMapping) {
        this.rsBrowser = rsBrowser;
        this.config = config;
        this.cssSkinResolver = (AbstractCssSkinVariantResolver)config.getGeneratorRegistry().getVariantResolver("skin");
        if (this.cssSkinResolver == null) {
            this.cssSkinResolver = new CssSkinVariantResolver();
            config.getGeneratorRegistry().registerVariantResolver(this.cssSkinResolver);
        }
        if (initSkinMapping) {
            String skinMappingType = config.getProperty("jawr.css.skin.type.mapping");
            if (StringUtils.isNotEmpty(skinMappingType)) {
                if (skinMappingType.equals("locale_skin") || skinMappingType.equals("skin_locale")) {
                    this.skinMappingType = skinMappingType;
                } else {
                    throw new IllegalArgumentException("The value for the 'locale_skin' property [" + skinMappingType + "] is invalid. " + "Please check the docs for valid values ");
                }
            }
            this.skinMapping = this.getSkinMapping(rsBrowser, config);
            this.resourceProviderStrategyClass = CssSkinVariantResourceProviderStrategy.class;
        }
    }

    @Override
    public void setResourceReaderHandler(ResourceReaderHandler rsHandler) {
        this.rsBrowser = rsHandler;
    }

    @Override
    public void setConfig(JawrConfig config) {
        this.config = config;
    }

    @Override
    public void afterPropertiesSet() {
        String skinMappingType;
        this.urlRewriter = new CssImageUrlRewriter(this.config);
        this.cssSkinResolver = (AbstractCssSkinVariantResolver)this.config.getGeneratorRegistry().getVariantResolver("skin");
        if (this.cssSkinResolver == null) {
            this.cssSkinResolver = new CssSkinVariantResolver();
            this.config.getGeneratorRegistry().registerVariantResolver(this.cssSkinResolver);
        }
        if (StringUtils.isNotEmpty(skinMappingType = this.config.getProperty("jawr.css.skin.type.mapping"))) {
            if (skinMappingType.equals("locale_skin") || skinMappingType.equals("skin_locale")) {
                this.skinMappingType = skinMappingType;
            } else {
                throw new IllegalArgumentException("The value for the 'locale_skin' property [" + skinMappingType + "] is invalid. " + "Please check the docs for valid values ");
            }
        }
        this.skinMapping = this.getSkinMapping(this.rsBrowser, this.config);
        this.resourceProviderStrategyClass = CssSkinVariantResourceProviderStrategy.class;
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public Map<String, VariantSet> getAvailableVariants(String mapping) {
        HashMap<String, VariantSet> availableVariants = new HashMap<String, VariantSet>();
        String skinRootDir = this.getSkinRootDir(mapping, this.skinMapping.keySet());
        if (skinRootDir != null) {
            Map<String, VariantSet> variantSets = this.skinMapping.get(skinRootDir);
            for (VariantSet variantSet : variantSets.values()) {
                availableVariants.put(variantSet.getType(), variantSet);
            }
        }
        return availableVariants;
    }

    @Override
    protected Reader generateResourceForBundle(GeneratorContext context) {
        Reader reader = null;
        ResourceReaderHandler readerHandler = context.getResourceReaderHandler();
        String path = context.getPath();
        String skinRootDir = this.getSkinRootDir(path, this.skinMapping.keySet());
        Map<String, VariantSet> ctxVariantSetMap = this.skinMapping.get(skinRootDir);
        String skinVariantPath = path.substring(skinRootDir.length());
        String[] paths = skinVariantPath.split("/");
        VariantResourceReaderStrategy strategy = this.getVariantStrategy(context, ctxVariantSetMap);
        Map<String, String> variantMap = null;
        do {
            if ((variantMap = strategy.nextVariantMapConbination()) == null) continue;
            reader = this.getResourceReader(path, readerHandler, skinRootDir, paths, variantMap);
        } while (variantMap != null && reader == null);
        return reader;
    }

    @Override
    public Set<String> getResourceNames(String path) {
        String resourcePath = this.getResolver().getResourcePath(path);
        return this.rsBrowser.getResourceNames(resourcePath);
    }

    @Override
    public boolean isDirectory(String path) {
        String resourcePath = this.getResolver().getResourcePath(path);
        return this.rsBrowser.isDirectory(resourcePath);
    }

    public Map<String, Map<String, VariantSet>> getSkinMapping(ResourceBrowser rsBrowser, JawrConfig config) {
        HashMap<String, Map<String, VariantSet>> skinMapping = new HashMap<String, Map<String, VariantSet>>();
        PropertiesConfigHelper props = new PropertiesConfigHelper(config.getConfigProperties(), "css");
        Set<String> skinRootDirectories = props.getPropertyAsSet("skin.default.root.dirs");
        if (this.skinMappingType.equals("skin_locale")) {
            this.updateSkinMappingUsingTypeSkinLocale(rsBrowser, config, skinMapping, skinRootDirectories);
        } else {
            this.updateSkinMappingUsingTypeLocaleSkin(rsBrowser, config, skinMapping, skinRootDirectories);
        }
        return skinMapping;
    }

    private void updateSkinMappingUsingTypeSkinLocale(ResourceBrowser rsBrowser, JawrConfig config, Map<String, Map<String, VariantSet>> skinMapping, Set<String> skinRootDirectories) {
        String defaultSkinName = null;
        String defaultLocaleName = null;
        Iterator<String> itRootDir = skinRootDirectories.iterator();
        while (itRootDir.hasNext()) {
            String defaultSkinDir = PathNormalizer.asDirPath(itRootDir.next());
            String defaultSkinDirName = PathNormalizer.getPathName(defaultSkinDir);
            String skinRootDir = PathNormalizer.getParentPath(defaultSkinDir);
            String skinName = null;
            String localeName = null;
            if (LocaleUtils.LOCALE_SUFFIXES.contains(defaultSkinDirName)) {
                localeName = defaultSkinDirName;
                skinName = PathNormalizer.getPathName(skinRootDir);
                skinRootDir = PathNormalizer.getParentPath(skinRootDir);
            } else {
                skinName = defaultSkinDirName;
            }
            if (defaultSkinName == null) {
                defaultSkinName = skinName;
            } else if (!defaultSkinName.equals(skinName)) {
                throw new BundlingProcessException("The default skin for the skin root directories are not the same. Please check your configuration.");
            }
            if (defaultLocaleName == null) {
                defaultLocaleName = localeName;
            } else if (defaultLocaleName != null && !defaultLocaleName.equals(localeName)) {
                throw new BundlingProcessException("The default locale for the skin root directories are not the same. Please check your configuration.");
            }
            this.checkRootDirectoryNotOverlap(defaultSkinDir, skinRootDirectories);
            Map<String, VariantSet> variantsMap = this.getVariants(rsBrowser, skinRootDir, skinName, localeName, true);
            skinMapping.put(skinRootDir, variantsMap);
        }
        this.cssSkinResolver.setDefaultSkin(defaultSkinName);
        this.cssSkinResolver.setSkinCookieName(config.getSkinCookieName());
    }

    private void updateSkinMappingUsingTypeLocaleSkin(ResourceBrowser rsBrowser, JawrConfig config, Map<String, Map<String, VariantSet>> skinMapping, Set<String> skinRootDirectories) {
        String defaultSkinName = null;
        String defaultLocaleName = null;
        Iterator<String> itRootDir = skinRootDirectories.iterator();
        while (itRootDir.hasNext()) {
            String defaultLocaleDir = PathNormalizer.asDirPath(itRootDir.next());
            String defaultLocaleDirName = PathNormalizer.getPathName(defaultLocaleDir);
            String localeRootDir = PathNormalizer.getParentPath(defaultLocaleDir);
            String skinName = null;
            String localeName = null;
            if (!LocaleUtils.LOCALE_SUFFIXES.contains(defaultLocaleDirName)) {
                skinName = defaultLocaleDirName;
                localeName = PathNormalizer.getPathName(localeRootDir);
                localeRootDir = PathNormalizer.getParentPath(localeRootDir);
            } else {
                localeName = defaultLocaleDirName;
            }
            if (defaultSkinName == null) {
                defaultSkinName = skinName;
            } else if (!defaultSkinName.equals(skinName)) {
                throw new BundlingProcessException("The default skin for the skin root directories are not the same. Please check your configuration.");
            }
            if (defaultLocaleName == null) {
                defaultLocaleName = localeName;
            } else if (defaultLocaleName != null && !defaultLocaleName.equals(localeName)) {
                throw new BundlingProcessException("The default locale for the skin root directories are not the same. Please check your configuration.");
            }
            this.checkRootDirectoryNotOverlap(defaultLocaleDir, skinRootDirectories);
            Map<String, VariantSet> variantsMap = this.getVariants(rsBrowser, localeRootDir, skinName, localeName, false);
            skinMapping.put(localeRootDir, variantsMap);
        }
        CssSkinVariantResolver resolver = (CssSkinVariantResolver)config.getGeneratorRegistry().getVariantResolver("skin");
        if (resolver == null) {
            resolver = new CssSkinVariantResolver(defaultSkinName, config.getSkinCookieName());
            config.getGeneratorRegistry().registerVariantResolver(resolver);
        } else {
            resolver.setDefaultSkin(defaultSkinName);
            resolver.setSkinCookieName(config.getSkinCookieName());
        }
    }

    public String getSkinRootDir(String path, Set<String> skinRootDirs) {
        String skinRootDir = null;
        for (String skinDir : skinRootDirs) {
            if (!path.startsWith(skinDir)) continue;
            skinRootDir = skinDir;
        }
        return skinRootDir;
    }

    private Map<String, VariantSet> getVariants(ResourceBrowser rsBrowser, String rootDir, String defaultSkinName, String defaultLocaleName, boolean mappingSkinLocale) {
        Set<String> paths = rsBrowser.getResourceNames(rootDir);
        HashSet<String> skinNames = new HashSet<String>();
        HashSet<String> localeVariants = new HashSet<String>();
        Iterator<String> itPath = paths.iterator();
        while (itPath.hasNext()) {
            String path = rootDir + itPath.next();
            if (!rsBrowser.isDirectory(path)) continue;
            String dirName = PathNormalizer.getPathName(path);
            if (mappingSkinLocale) {
                skinNames.add(dirName);
                this.updateLocaleVariants(rsBrowser, path, localeVariants);
                continue;
            }
            if (!LocaleUtils.LOCALE_SUFFIXES.contains(dirName)) continue;
            localeVariants.add(dirName);
            this.updateSkinVariants(rsBrowser, path, skinNames);
        }
        return this.getVariants(defaultSkinName, skinNames, defaultLocaleName, localeVariants);
    }

    private Map<String, VariantSet> getVariants(String defaultSkin, Set<String> skinNames, String defaultLocaleName, Set<String> localeVariants) {
        HashMap<String, VariantSet> skinVariants = new HashMap<String, VariantSet>();
        if (!skinNames.isEmpty()) {
            skinVariants.put("skin", new VariantSet("skin", defaultSkin, skinNames));
        }
        if (!localeVariants.isEmpty()) {
            skinVariants.put("locale", new VariantSet("locale", defaultLocaleName, localeVariants));
        }
        return skinVariants;
    }

    private void updateLocaleVariants(ResourceBrowser rsBrowser, String path, Set<String> localeVariants) {
        Set<String> skinPaths = rsBrowser.getResourceNames(path);
        Iterator<String> itSkinPath = skinPaths.iterator();
        while (itSkinPath.hasNext()) {
            String skinDirName;
            String skinPath = path + itSkinPath.next();
            if (!rsBrowser.isDirectory(skinPath) || !LocaleUtils.LOCALE_SUFFIXES.contains(skinDirName = PathNormalizer.getPathName(skinPath))) continue;
            localeVariants.add(skinDirName);
        }
    }

    private void updateSkinVariants(ResourceBrowser rsBrowser, String path, Set<String> skinVariants) {
        Set<String> skinPaths = rsBrowser.getResourceNames(path);
        Iterator<String> itSkinPath = skinPaths.iterator();
        while (itSkinPath.hasNext()) {
            String skinPath = path + itSkinPath.next();
            if (!rsBrowser.isDirectory(skinPath)) continue;
            String skinDirName = PathNormalizer.getPathName(skinPath);
            skinVariants.add(skinDirName);
        }
    }

    private void checkRootDirectoryNotOverlap(String dir, Set<String> skinRootDirectories) {
        String rootDir = this.removeLocaleSuffixIfExist(dir);
        Iterator<String> itSkinDir = skinRootDirectories.iterator();
        while (itSkinDir.hasNext()) {
            String skinDir = PathNormalizer.asDirPath(itSkinDir.next());
            if (skinDir.equals(dir) || !(skinDir = this.removeLocaleSuffixIfExist(skinDir)).startsWith(rootDir)) continue;
            throw new BundlingProcessException("There is a misconfiguration. It is not allowed to have a skin root directory containing another one.");
        }
    }

    private String removeLocaleSuffixIfExist(String dir) {
        String result = dir;
        String dirName = PathNormalizer.getPathName(dir);
        if (LocaleUtils.LOCALE_SUFFIXES.contains(dirName)) {
            result = dir.substring(0, dir.indexOf("/" + dirName) + 1);
        }
        return result;
    }

    private VariantResourceReaderStrategy getVariantStrategy(GeneratorContext context, Map<String, VariantSet> variantSetMap) {
        VariantResourceReaderStrategy strategy = null;
        try {
            strategy = (VariantResourceReaderStrategy)this.resourceProviderStrategyClass.newInstance();
            strategy.initVariantProviderStrategy(context, variantSetMap);
        }
        catch (InstantiationException e) {
            throw new BundlingProcessException(e);
        }
        catch (IllegalAccessException e) {
            throw new BundlingProcessException(e);
        }
        return strategy;
    }

    private Reader getResourceReader(String originalPath, ResourceReaderHandler readerHandler, String skinRootDir, String[] paths, Map<String, String> variantMap) {
        Reader reader = null;
        StringBuffer path = new StringBuffer(skinRootDir);
        String skinVariant = variantMap.get("skin");
        String localeVariant = variantMap.get("locale");
        if (this.skinMappingType.equals("skin_locale")) {
            paths[0] = skinVariant;
            if (localeVariant != null) {
                paths[1] = localeVariant;
            }
        } else {
            paths[0] = localeVariant;
            if (skinVariant != null) {
                paths[1] = skinVariant;
            }
        }
        for (int i = 0; i < paths.length; ++i) {
            path.append(paths[i]);
            if (i + 1 >= paths.length) continue;
            path.append("/");
        }
        try {
            String finalPath = path.toString();
            reader = readerHandler.getResource(finalPath);
            if (!originalPath.equals(finalPath)) {
                String content = IOUtils.toString(reader);
                StringBuffer result = this.urlRewriter.rewriteUrl(finalPath, originalPath, content);
                reader = new StringReader(result.toString());
            }
        }
        catch (ResourceNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return reader;
    }

    public void setVariantResourceReaderStrategy(Class<?> strategyClass) {
        this.resourceProviderStrategyClass = strategyClass;
    }

    @Override
    public InputStream createResourceAsStream(GeneratorContext context) {
        String path = context.getPath();
        InputStream is = null;
        if (FileNameUtils.hasImageExtension(path)) {
            try {
                is = context.getResourceReaderHandler().getResourceAsStream(path, false);
            }
            catch (ResourceNotFoundException e) {
                // empty catch block
            }
        }
        return is;
    }

    @Override
    public boolean isHandlingCssImage() {
        return false;
    }
}

