/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.JavascriptStringUtil;
import net.jawr.web.resource.bundle.handler.ClientSideHandlerGenerator;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.postprocess.impl.JSMinPostProcessor;
import net.jawr.web.servlet.RendererRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClientSideHandlerGeneratorImpl
implements ClientSideHandlerGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ClientSideHandlerGeneratorImpl.class.getName());
    protected List<JoinableResourceBundle> globalBundles;
    protected List<JoinableResourceBundle> contextBundles;
    protected JawrConfig config;
    private static StringBuffer mainScriptTemplate;
    private static StringBuffer debugScriptTemplate;

    @Override
    public void init(JawrConfig config, List<JoinableResourceBundle> globalBundles, List<JoinableResourceBundle> contextBundles) {
        if (null == mainScriptTemplate) {
            mainScriptTemplate = this.loadScriptTemplate("/net/jawr/web/resource/bundle/handler/handler.js");
        }
        if (null == debugScriptTemplate) {
            debugScriptTemplate = this.loadScriptTemplate("/net/jawr/web/resource/bundle/handler/debughandler.js");
        }
        this.globalBundles = globalBundles;
        this.contextBundles = contextBundles;
        this.config = config;
    }

    @Override
    public StringBuffer getClientSideHandlerScript(HttpServletRequest request) {
        StringBuffer sb = this.getHeaderSection(request);
        boolean useGzip = RendererRequestUtils.isRequestGzippable(request, this.config);
        Map<String, String> variants = this.config.getGeneratorRegistry().resolveVariants(request);
        sb.append("JAWR.loader.mapping='").append(this.getPathPrefix(request, this.config)).append("';\n");
        sb.append("(function(){\n");
        sb.append("function r(n, p, i,ie,aU){return new JAWR.ResourceBundle(n, p, i,ie,aU);}\n");
        sb.append("JAWR.loader.jsbundles = [");
        sb.append(this.getClientSideBundles(variants, useGzip));
        sb.append("]\n");
        ResourceBundlesHandler rsHandler = (ResourceBundlesHandler)request.getSession().getServletContext().getAttribute("net.jawr.web.resource.bundle.CSS_CONTEXT_ATTRIBUTE");
        boolean isCSSHandler = false;
        if (null != rsHandler) {
            ClientSideHandlerGenerator generator = rsHandler.getClientSideHandler();
            if (this != generator) {
                variants = rsHandler.getConfig().getGeneratorRegistry().resolveVariants(request);
                sb.append(";JAWR.loader.cssbundles = [");
                sb.append(generator.getClientSideBundles(variants, useGzip));
                sb.append("];\n");
            } else {
                isCSSHandler = true;
            }
            sb.append("JAWR.loader.cssmapping='").append(this.getPathPrefix(request, rsHandler.getConfig())).append("';\n");
        }
        sb.append("})();");
        if (this.config.isDebugModeOn()) {
            sb.append(debugScriptTemplate.toString()).append("\n");
        }
        for (JoinableResourceBundle bundle : this.globalBundles) {
            String func = isCSSHandler ? "JAWR.loader.style(" : "JAWR.loader.script(";
            sb.append(func).append(JavascriptStringUtil.quote(bundle.getId())).append(");\n");
        }
        if (!this.config.isDebugModeOn()) {
            JSMinPostProcessor p = new JSMinPostProcessor();
            try {
                sb = p.minifyStringBuffer(sb, this.config.getResourceCharset());
            }
            catch (Exception e) {
                throw new BundlingProcessException("Unexpected error creating client side resource handler", e);
            }
        }
        return sb;
    }

    protected StringBuffer getHeaderSection(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(mainScriptTemplate.toString());
        sb.append("JAWR.app_context_path='").append(request.getContextPath()).append("';\n");
        return sb;
    }

    @Override
    public StringBuffer getClientSideBundles(Map<String, String> variants, boolean useGzip) {
        StringBuffer sb = new StringBuffer();
        this.addAllBundles(this.globalBundles, variants, sb, useGzip);
        if (!this.globalBundles.isEmpty() && !this.contextBundles.isEmpty()) {
            sb.append(",");
        }
        this.addAllBundles(this.contextBundles, variants, sb, useGzip);
        return sb;
    }

    private String getPathPrefix(HttpServletRequest request, JawrConfig config) {
        if (request.isSecure()) {
            if (null != config.getContextPathSslOverride()) {
                return config.getContextPathSslOverride();
            }
        } else if (null != config.getContextPathOverride()) {
            return config.getContextPathOverride();
        }
        String mapping = null == config.getServletMapping() ? "" : config.getServletMapping();
        String path = PathNormalizer.joinPaths(request.getContextPath(), mapping);
        path = path.endsWith("/") ? path : path + '/';
        return path;
    }

    private void addAllBundles(List<JoinableResourceBundle> bundles, Map<String, String> variants, StringBuffer buf, boolean useGzip) {
        Iterator<JoinableResourceBundle> it = bundles.iterator();
        while (it.hasNext()) {
            JoinableResourceBundle bundle = it.next();
            this.appendBundle(bundle, variants, buf, useGzip);
            if (!it.hasNext()) continue;
            buf.append(",");
        }
    }

    private void appendBundle(JoinableResourceBundle bundle, Map<String, String> variants, StringBuffer buf, boolean useGzip) {
        buf.append("r(").append(JavascriptStringUtil.quote(bundle.getId())).append(",");
        String path = bundle.getURLPrefix(variants);
        if (useGzip) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            buf.append(JavascriptStringUtil.quote("/gzip_" + path));
        } else {
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            buf.append(JavascriptStringUtil.quote(path));
        }
        boolean skipItems = false;
        if (bundle.getItemPathList().size() == 1 && null == bundle.getExplorerConditionalExpression()) {
            skipItems = bundle.getItemPathList().get(0).getPath().equals(bundle.getId());
        }
        if (!skipItems) {
            buf.append(",[");
            Iterator<BundlePath> it = bundle.getItemPathList(variants).iterator();
            while (it.hasNext()) {
                path = it.next().getPath();
                if (this.config.getGeneratorRegistry().isPathGenerated(path)) {
                    path = PathNormalizer.createGenerationPath(path, this.config.getGeneratorRegistry(), null);
                }
                if ("".equals(this.config.getContextPathOverride()) && path.startsWith("/")) {
                    path = path.substring(1);
                }
                buf.append(JavascriptStringUtil.quote(path));
                if (!it.hasNext()) continue;
                buf.append(",");
            }
            buf.append("]");
            if (null != bundle.getExplorerConditionalExpression()) {
                buf.append(",'").append(bundle.getExplorerConditionalExpression()).append("'");
            }
        }
        if (null != bundle.getAlternateProductionURL()) {
            if (skipItems) {
                buf.append(",null,null");
            } else if (null == bundle.getExplorerConditionalExpression()) {
                buf.append(",null");
            }
            buf.append("," + JavascriptStringUtil.quote(bundle.getAlternateProductionURL()));
        }
        buf.append(")");
    }

    private StringBuffer loadScriptTemplate(String path) {
        StringWriter sw = new StringWriter();
        InputStream is = null;
        try {
            int i;
            is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            while ((i = is.read()) != -1) {
                sw.write(i);
            }
        }
        catch (IOException e) {
            Marker fatal = MarkerFactory.getMarker((String)"FATAL");
            LOGGER.error(fatal, "a serious error occurred when initializing ClientSideHandlerGeneratorImpl");
            throw new BundlingProcessException("Classloading issues prevent loading the loader template to be loaded. ", e);
        }
        finally {
            IOUtils.close(is);
        }
        return sw.getBuffer();
    }
}

