/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.iexplore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IENamedResourceFilter {
    private static final String COMMENTS_REGEX = "^.*_ie(.js|.css)$";
    private static final String OPERATORS_REGEX = "(_(lt|lte|gt|gte))?(_\\d(\\.(\\d)*)?)?_ie(.js|.css)$";
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("^.*_ie(.js|.css)$", 2);
    private static final Pattern OPERATORS_PATTERN = Pattern.compile("(_(lt|lte|gt|gte))?(_\\d(\\.(\\d)*)?)?_ie(.js|.css)$", 2);

    public Map<String, List<String>> filterPathSet(Collection<String> paths) {
        HashMap<String, List<String>> expressions = new HashMap<String, List<String>>();
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator<String> it = paths.iterator();
        while (it.hasNext()) {
            List<String> fileNames;
            String path = it.next().toString();
            if (!COMMENTS_PATTERN.matcher(path).matches()) continue;
            Matcher matcher = OPERATORS_PATTERN.matcher(path);
            matcher.find();
            String sufix = matcher.group();
            sufix = sufix.substring(0, sufix.lastIndexOf("."));
            String expressionKey = this.createExpressionKey(sufix);
            if (expressions.containsKey(expressionKey)) {
                fileNames = (List)expressions.get(expressionKey);
                fileNames.add(path);
            } else {
                fileNames = new ArrayList();
                fileNames.add(path);
                expressions.put(expressionKey, fileNames);
            }
            toRemove.add(path);
        }
        it = toRemove.iterator();
        while (it.hasNext()) {
            paths.remove(it.next());
        }
        return expressions;
    }

    private String createExpressionKey(String sufix) {
        String[] parts = sufix.split("_");
        StringBuffer ret = new StringBuffer("[if ");
        boolean ieAdded = false;
        for (int i = 0; i < parts.length; ++i) {
            if ("".equals(parts[i])) continue;
            if ("ie".equals(parts[i])) break;
            if (Pattern.matches("(lt|lte|gt|gte)", parts[i])) {
                ret.append(parts[i] + " ");
                continue;
            }
            ret.append("IE " + parts[i]);
            ieAdded = true;
        }
        if (!ieAdded) {
            ret.append("IE");
        }
        ret.append("]");
        return ret.toString();
    }
}

