/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.util.StringUtils;

public class LocaleUtils {
    private static final String MSG_RESOURCE_BUNDLE_SUFFIX = ".properties";
    public static final Set<String> LOCALE_SUFFIXES = LocaleUtils.getAvailableLocaleSuffixes();

    public static boolean matchesFilter(String key, List<String> filters) {
        boolean rets;
        boolean bl = rets = null == filters;
        if (!rets) {
            Iterator<String> it = filters.iterator();
            while (it.hasNext() && !rets) {
                rets = key.startsWith(it.next());
            }
        }
        return rets;
    }

    public static String getLocalizedBundleName(String bundleName, String localeKey) {
        String newName = bundleName;
        int idxSeparator = bundleName.lastIndexOf(46);
        if (StringUtils.isNotEmpty(localeKey) && idxSeparator != -1) {
            newName = bundleName.substring(0, idxSeparator);
            newName = newName + '_' + localeKey;
            newName = newName + bundleName.substring(idxSeparator);
        }
        return newName;
    }

    public static List<String> getAvailableLocaleSuffixesForBundle(String messageBundlePath) {
        return LocaleUtils.getAvailableLocaleSuffixesForBundle(messageBundlePath, MSG_RESOURCE_BUNDLE_SUFFIX, null);
    }

    public static List<String> getAvailableLocaleSuffixesForBundle(String messageBundlePath, ServletContext servletContext) {
        return LocaleUtils.getAvailableLocaleSuffixesForBundle(messageBundlePath, MSG_RESOURCE_BUNDLE_SUFFIX, servletContext);
    }

    public static List<String> getAvailableLocaleSuffixesForBundle(String messageBundlePath, String fileSuffix) {
        return LocaleUtils.getAvailableLocaleSuffixesForBundle(messageBundlePath, fileSuffix, null);
    }

    public static List<String> getAvailableLocaleSuffixesForBundle(String messageBundlePath, String fileSuffix, ServletContext servletContext) {
        int idxNameSpace = messageBundlePath.indexOf("(");
        int idxFilter = messageBundlePath.indexOf("[");
        int idx = -1;
        if (idxNameSpace != -1 && idxFilter != -1) {
            idx = Math.min(idxNameSpace, idxFilter);
        } else if (idxNameSpace != -1 && idxFilter == -1) {
            idx = idxNameSpace;
        } else if (idxNameSpace == -1 && idxFilter != -1) {
            idx = idxFilter;
        }
        String messageBundle = null;
        messageBundle = idx > 0 ? messageBundlePath.substring(0, idx) : messageBundlePath;
        return LocaleUtils.getAvailableLocaleSuffixes(messageBundle, fileSuffix, servletContext);
    }

    public static List<String> getAvailableLocaleSuffixes(String messageBundle, ServletContext servletContext) {
        return LocaleUtils.getAvailableLocaleSuffixes(messageBundle, MSG_RESOURCE_BUNDLE_SUFFIX, servletContext);
    }

    public static List<String> getAvailableLocaleSuffixes(String messageBundles, String fileSuffix, ServletContext servletContext) {
        String[] msgBundleArray;
        HashSet<String> availableLocaleSuffixes = new HashSet<String>();
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (String messageBundle : msgBundleArray = messageBundles.split("\\|")) {
            LocaleUtils.addSuffixIfAvailable(messageBundle, availableLocaleSuffixes, null, fileSuffix, servletContext);
            for (int i = 0; i < availableLocales.length; ++i) {
                Locale locale = availableLocales[i];
                LocaleUtils.addSuffixIfAvailable(messageBundle, availableLocaleSuffixes, locale, fileSuffix, servletContext);
            }
        }
        return new ArrayList<String>(availableLocaleSuffixes);
    }

    private static void addSuffixIfAvailable(String messageBundlePath, Set<String> availableLocaleSuffixes, Locale locale, String fileSuffix, ServletContext servletContext) {
        String localMsgResourcePath = LocaleUtils.toBundleName(messageBundlePath, locale) + fileSuffix;
        URL resourceUrl = null;
        try {
            resourceUrl = ClassLoaderResourceUtils.getResourceURL(localMsgResourcePath, LocaleUtils.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (resourceUrl == null && servletContext != null && localMsgResourcePath.startsWith("grails-app/")) {
            try {
                resourceUrl = servletContext.getResource("/WEB-INF/" + localMsgResourcePath);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (resourceUrl != null) {
            String suffix = localMsgResourcePath.substring(messageBundlePath.length());
            if (suffix.length() > 0) {
                suffix = suffix.length() == fileSuffix.length() ? "" : suffix.substring(1, suffix.length() - fileSuffix.length());
            }
            availableLocaleSuffixes.add(suffix);
        }
    }

    public static String toBundleName(String bundleBaseName, Locale locale) {
        String baseName = bundleBaseName.replace('.', '/');
        if (locale == null) {
            return baseName;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (StringUtils.isEmpty(language) && StringUtils.isEmpty(country) && StringUtils.isEmpty(variant)) {
            return baseName;
        }
        StringBuffer sb = new StringBuffer(baseName);
        sb.append('_');
        if (StringUtils.isNotEmpty(variant)) {
            sb.append(language).append('_').append(country).append('_').append(variant);
        } else if (StringUtils.isNotEmpty(country)) {
            sb.append(language).append('_').append(country);
        } else {
            sb.append(language);
        }
        return sb.toString();
    }

    public static Set<String> getAvailableLocaleSuffixes() {
        HashSet<String> availableLocaleSuffixes = new HashSet<String>();
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (int i = 0; i < availableLocales.length; ++i) {
            Locale locale = availableLocales[i];
            StringBuffer sb = new StringBuffer();
            if (locale != null) {
                String language = locale.getLanguage();
                String country = locale.getCountry();
                String variant = locale.getVariant();
                if (StringUtils.isNotEmpty(variant)) {
                    sb.append(language).append('_').append(country).append('_').append(variant);
                } else if (StringUtils.isNotEmpty(country)) {
                    sb.append(language).append('_').append(country);
                } else {
                    sb.append(language);
                }
            }
            availableLocaleSuffixes.add(sb.toString());
        }
        return availableLocaleSuffixes;
    }
}

