/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale;

import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.generator.AbstractJavascriptGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.generator.variant.VariantResourceGenerator;
import net.jawr.web.resource.bundle.locale.LocaleUtils;
import net.jawr.web.resource.bundle.locale.message.MessageBundleScriptCreator;
import net.jawr.web.resource.bundle.variant.VariantSet;

public class ResourceBundleMessagesGenerator
extends AbstractJavascriptGenerator
implements VariantResourceGenerator {
    private ResourceGeneratorResolver resolver;
    private final Map<String, List<String>> cachedAvailableLocalePerResource = new ConcurrentHashMap<String, List<String>>();

    public ResourceBundleMessagesGenerator() {
        this.resolver = ResourceGeneratorResolverFactory.createPrefixResolver("messages");
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public Reader createResource(GeneratorContext context) {
        MessageBundleScriptCreator creator = new MessageBundleScriptCreator(context);
        return creator.createScript(context.getCharset());
    }

    @Override
    public String getDebugModeBuildTimeGenerationPath(String path) {
        String debugPath = path.replaceFirst(":", "/");
        if (debugPath.endsWith("@")) {
            debugPath = debugPath.replaceAll("@", "");
        } else {
            debugPath = debugPath.replaceAll("@", "_");
            debugPath = debugPath.replaceAll("\\|", "_");
        }
        return debugPath + "." + "js";
    }

    public List<String> getAvailableLocales(String resource) {
        List<String> availableLocales = this.cachedAvailableLocalePerResource.get(resource);
        if (availableLocales != null) {
            return availableLocales;
        }
        availableLocales = this.findAvailableLocales(resource);
        this.cachedAvailableLocalePerResource.put(resource, availableLocales);
        return availableLocales;
    }

    protected List<String> findAvailableLocales(String resource) {
        List<String> availableLocales = LocaleUtils.getAvailableLocaleSuffixesForBundle(resource);
        return availableLocales;
    }

    @Override
    public Map<String, VariantSet> getAvailableVariants(String resource) {
        List<String> localeVariants = this.getAvailableLocales(resource);
        if (localeVariants.isEmpty()) {
            throw new BundlingProcessException("Enable to find the resource bundle : " + resource);
        }
        HashMap<String, VariantSet> variants = new HashMap<String, VariantSet>();
        VariantSet variantSet = new VariantSet("locale", "", localeVariants);
        variants.put("locale", variantSet);
        return variants;
    }
}

