/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale.message;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.jawr.web.resource.bundle.generator.JavascriptStringUtil;

public class BundleStringJsonifier {
    private Map<String, Object> keyMap;
    private Properties bundleValues;
    private boolean addQuoteToKey;
    private static final String FUNC = "p(";

    public BundleStringJsonifier(Properties bundleValues, boolean addQuoteToKey) {
        this.addQuoteToKey = addQuoteToKey;
        this.bundleValues = bundleValues;
        this.keyMap = new HashMap<String, Object>();
        Enumeration<Object> keys = this.bundleValues.keys();
        while (keys.hasMoreElements()) {
            this.processKey((String)keys.nextElement());
        }
    }

    private void processKey(String key) {
        StringTokenizer tk = new StringTokenizer(key, ".");
        Map currentMap = this.keyMap;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (!currentMap.containsKey(token)) {
                currentMap.put(token, new HashMap());
            }
            currentMap = (Map)currentMap.get(token);
        }
    }

    public StringBuffer serializeBundles() {
        StringBuffer sb = new StringBuffer("{");
        Iterator<String> it = this.keyMap.keySet().iterator();
        while (it.hasNext()) {
            String currentKey = it.next();
            this.handleKey(sb, this.keyMap, currentKey, currentKey, !it.hasNext());
        }
        return sb.append("}");
    }

    private void handleKey(StringBuffer sb, Map<String, Object> currentLeaf, String currentKey, String fullKey, boolean isLeafLast) {
        Map newLeaf = (Map)currentLeaf.get(currentKey);
        if (this.bundleValues.containsKey(fullKey)) {
            this.addValuedKey(sb, currentKey, fullKey);
            if (!newLeaf.isEmpty()) {
                sb.append(",({");
                Iterator it = newLeaf.keySet().iterator();
                while (it.hasNext()) {
                    String newKey = (String)it.next();
                    this.handleKey(sb, newLeaf, newKey, fullKey + "." + newKey, !it.hasNext());
                }
                sb.append("}))");
            } else {
                sb.append(")");
            }
        } else if (!newLeaf.isEmpty()) {
            sb.append(this.getJsonKey(currentKey)).append(":{");
            Iterator it = newLeaf.keySet().iterator();
            while (it.hasNext()) {
                String newKey = (String)it.next();
                this.handleKey(sb, newLeaf, newKey, fullKey + "." + newKey, !it.hasNext());
            }
            sb.append("}");
        }
        if (!isLeafLast) {
            sb.append(",");
        }
    }

    private String getJsonKey(String key) {
        String jsonKey = key;
        if (this.addQuoteToKey) {
            jsonKey = JavascriptStringUtil.quote(key);
        }
        return jsonKey;
    }

    private void addValuedKey(StringBuffer sb, String key, String fullKey) {
        sb.append(this.getJsonKey(key)).append(":").append(FUNC).append(JavascriptStringUtil.quote(this.bundleValues.get(fullKey).toString()));
    }
}

