/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.locale.message.BundleStringJsonifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MessageBundleScriptCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MessageBundleScriptCreator.class.getName());
    public static final String DEFAULT_NAMESPACE = "messages";
    private static final String SCRIPT_TEMPLATE = "/net/jawr/web/resource/bundle/message/messages.js";
    private static final String DEFAULT_RESOURCE_BUNDLE_CHARSET = "ISO-8859-1";
    protected static StringBuffer template;
    protected String configParam;
    protected String namespace;
    private String filter;
    protected Locale locale;
    protected List<String> filterList;
    protected ServletContext servletContext;
    protected boolean fallbackToSystemLocale = true;
    protected boolean addQuoteToMessageKey = false;
    protected Charset resourceBundleCharset;

    public MessageBundleScriptCreator(GeneratorContext context) {
        this.servletContext = context.getServletContext();
        if (null == template) {
            template = this.loadScriptTemplate();
        }
        this.locale = context.getLocale();
        this.namespace = context.getParenthesesParam();
        this.namespace = null == this.namespace ? DEFAULT_NAMESPACE : this.namespace;
        this.filter = context.getBracketsParam();
        if (null != this.filter) {
            StringTokenizer tk = new StringTokenizer(this.filter, "\\|");
            this.filterList = new ArrayList<String>();
            while (tk.hasMoreTokens()) {
                this.filterList.add(tk.nextToken());
            }
        }
        this.configParam = context.getPath();
        Properties configProperties = context.getConfig().getConfigProperties();
        this.fallbackToSystemLocale = PropertiesConfigHelper.getBooleanValue(configProperties, "jawr.locale.generator.fallbackToSystemLocale", true);
        this.addQuoteToMessageKey = PropertiesConfigHelper.getBooleanValue(configProperties, "jawr.locale.generator.quoteMsgKey", false);
        String charsetName = context.getConfig().getProperty("jawr.locale.generator.resourceBundle.charset", DEFAULT_RESOURCE_BUNDLE_CHARSET);
        this.resourceBundleCharset = Charset.forName(charsetName);
    }

    private StringBuffer loadScriptTemplate() {
        StringWriter sw = new StringWriter();
        InputStream is = null;
        try {
            is = ClassLoaderResourceUtils.getResourceAsStream(SCRIPT_TEMPLATE, this);
            IOUtils.copy(is, (Writer)sw);
        }
        catch (IOException e) {
            Marker fatal = MarkerFactory.getMarker((String)"FATAL");
            LOGGER.error(fatal, "a serious error occurred when initializing MessageBundleScriptCreator");
            throw new BundlingProcessException("Classloading issues prevent loading the message template to be loaded. ", e);
        }
        finally {
            IOUtils.close(is);
        }
        return sw.getBuffer();
    }

    public Reader createScript(Charset charset) {
        String[] names = this.configParam.split("\\|");
        Properties props = new Properties();
        Locale currentLocale = this.getLocaleToApply();
        MessageBundleControl control = new MessageBundleControl(this.fallbackToSystemLocale, this.resourceBundleCharset);
        for (int x = 0; x < names.length; ++x) {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle(names[x], currentLocale, control);
            }
            catch (MissingResourceException ex) {
                try {
                    bundle = ResourceBundle.getBundle(names[x], currentLocale, this.getClass().getClassLoader(), control);
                }
                catch (Exception e) {
                    bundle = ResourceBundle.getBundle(names[x], currentLocale, Thread.currentThread().getContextClassLoader(), control);
                }
            }
            this.updateProperties(bundle, props, charset);
        }
        return this.doCreateScript(props);
    }

    protected Locale getLocaleToApply() {
        Locale currentLocale = this.locale;
        if (currentLocale == null) {
            currentLocale = this.fallbackToSystemLocale ? Locale.getDefault() : new Locale("", "");
        }
        return currentLocale;
    }

    public Reader createScript(Charset charset, ResourceBundle bundle) {
        Properties props = new Properties();
        this.updateProperties(bundle, props, charset);
        return this.doCreateScript(props);
    }

    public void updateProperties(ResourceBundle bundle, Properties props, Charset charset) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!this.matchesFilter(key)) continue;
            String value = bundle.getString(key);
            props.put(key, value);
        }
    }

    protected Reader doCreateScript(Properties props) {
        BundleStringJsonifier bsj = new BundleStringJsonifier(props, this.addQuoteToMessageKey);
        String script = template.toString();
        String messages = bsj.serializeBundles().toString();
        script = script.replaceFirst("@namespace", RegexUtil.adaptReplacementToMatcher(this.namespace));
        script = script.replaceFirst("@messages", RegexUtil.adaptReplacementToMatcher(messages));
        return new StringReader(script);
    }

    protected boolean matchesFilter(String key) {
        boolean rets;
        boolean bl = rets = null == this.filterList;
        if (!rets) {
            Iterator<String> it = this.filterList.iterator();
            while (it.hasNext() && !rets) {
                rets = key.startsWith(it.next());
            }
        }
        return rets;
    }

    public class MessageBundleControl
    extends ResourceBundle.Control {
        private boolean fallbackToSystemLocale = true;
        private Charset charset;

        public MessageBundleControl(boolean fallbackToSystemLocale, Charset charset) {
            this.fallbackToSystemLocale = fallbackToSystemLocale;
            this.charset = charset;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            Locale defaultLocale = Locale.getDefault();
            defaultLocale = this.fallbackToSystemLocale ? Locale.getDefault() : new Locale("", "");
            return locale.equals(defaultLocale) ? null : defaultLocale;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            ResourceBundle bundle;
            block8: {
                block9: {
                    String bundleName;
                    block7: {
                        bundleName = this.toBundleName(baseName, locale);
                        bundle = null;
                        if (!format.equals("java.class")) break block7;
                        try {
                            Class<?> bundleClass = loader.loadClass(bundleName);
                            if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                                throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                            }
                            bundle = (ResourceBundle)bundleClass.newInstance();
                        }
                        catch (ClassNotFoundException e) {}
                        break block8;
                    }
                    if (!format.equals("java.properties")) break block9;
                    final String resourceName = this.toResourceName(bundleName, "properties");
                    final ClassLoader classLoader = loader;
                    final boolean reloadFlag = reload;
                    InputStream stream = null;
                    InputStreamReader rd = null;
                    try {
                        stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                            @Override
                            public InputStream run() throws IOException {
                                InputStream is = null;
                                if (reloadFlag) {
                                    URLConnection connection;
                                    URL url = classLoader.getResource(resourceName);
                                    if (url != null && (connection = url.openConnection()) != null) {
                                        connection.setUseCaches(false);
                                        is = connection.getInputStream();
                                    }
                                } else {
                                    is = classLoader.getResourceAsStream(resourceName);
                                }
                                return is;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (IOException)e.getException();
                    }
                    if (stream == null) break block8;
                    try {
                        rd = new InputStreamReader(stream, this.charset);
                        bundle = new PropertyResourceBundle(rd);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(rd);
                        IOUtils.close(stream);
                        throw throwable;
                    }
                    IOUtils.close(rd);
                    IOUtils.close(stream);
                    break block8;
                }
                throw new IllegalArgumentException("unknown format: " + format);
            }
            return bundle;
        }
    }
}

