/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.minification.JSMin;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.impl.AbstractJsChainedResourceBundlePostProcessor;

public class JSMinPostProcessor
extends AbstractJsChainedResourceBundlePostProcessor {
    private static final String LF = "\n";
    private static final String CR_LF = "\r\n";

    public JSMinPostProcessor() {
        super("JSMin");
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleString) throws IOException {
        Charset charset = status.getJawrConfig().getResourceCharset();
        String bundleContent = bundleString.toString().replaceAll(CR_LF, LF);
        byte[] bundleBytes = bundleContent.getBytes(charset.name());
        ByteArrayInputStream bIs = new ByteArrayInputStream(bundleBytes);
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(bIs, bOs);
        try {
            minifier.jsmin();
        }
        catch (JSMin.JSMinException e) {
            this.formatAndThrowJSLintError(status, bundleBytes, e);
        }
        byte[] minified = bOs.toByteArray();
        return this.byteArrayToString(charset, minified);
    }

    public StringBuffer minifyStringBuffer(StringBuffer sb, Charset charset) throws IOException, JSMin.JSMinException {
        byte[] bundleBytes = sb.toString().getBytes(charset.name());
        ByteArrayInputStream bIs = new ByteArrayInputStream(bundleBytes);
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(bIs, bOs);
        minifier.jsmin();
        byte[] minified = bOs.toByteArray();
        return this.byteArrayToString(charset, minified);
    }

    private StringBuffer byteArrayToString(Charset charset, byte[] minified) throws IOException {
        ReadableByteChannel chan = Channels.newChannel(new ByteArrayInputStream(minified));
        Reader rd = Channels.newReader(chan, charset.newDecoder(), -1);
        StringWriter writer = new StringWriter();
        IOUtils.copy(rd, writer, true);
        return writer.getBuffer();
    }

    private void formatAndThrowJSLintError(BundleProcessingStatus status, byte[] bundleBytes, JSMin.JSMinException e) {
        StringBuffer errorMsg = new StringBuffer("JSMin failed to minify the bundle with id: '" + status.getCurrentBundle().getId() + "'.\n");
        errorMsg.append("The exception thrown is of type:" + e.getClass().getName() + "'.\n");
        int currentByte = e.getByteIndex();
        int startPoint = currentByte < 100 ? 0 : currentByte - 100;
        int totalSize = currentByte - startPoint;
        byte[] lastData = new byte[totalSize];
        for (int x = 0; x < totalSize; ++x) {
            lastData[x] = bundleBytes[startPoint];
            ++startPoint;
        }
        errorMsg.append("The error happened at this point in your javascript (line " + e.getLine() + "; col. " + e.getColumn() + ") : \n");
        errorMsg.append("_______________________________________________\n...");
        try {
            String data = this.byteArrayToString(status.getJawrConfig().getResourceCharset(), lastData).toString();
            errorMsg.append(data).append("\n\n");
        }
        catch (IOException e1) {
            // empty catch block
        }
        errorMsg.append("_______________________________________________");
        errorMsg.append("\nIf you can't find the error, try to check the scripts using JSLint (http://www.jslint.com/) to find the conflicting part of the code. ");
        throw new BundlingProcessException(errorMsg.toString(), e);
    }
}

