/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl.js.uglify;

import java.io.FileNotFoundException;
import java.io.InputStream;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.minification.CompressionResult;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.util.StringUtils;
import net.jawr.web.util.js.RhinoEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class UglifyJS {
    private static final String[] UGLIFY_SCRIPTS = new String[]{"utils.js", "ast.js", "parse.js", "transform.js", "scope.js", "output.js", "compress.js", "sourcemap.js", "uglify.js"};
    private RhinoEngine rhinoEngine = new RhinoEngine();
    private final JawrConfig config;
    private String optionsInJson;

    public UglifyJS(JawrConfig config, String scriptDirLocation, String optionsInJson) {
        this.config = config;
        this.optionsInJson = optionsInJson;
        String baseJsLocation = StringUtils.isNotEmpty(scriptDirLocation) ? scriptDirLocation : "/net/jawr/web/resource/bundle/postprocessor/js/uglify/";
        for (String script : UGLIFY_SCRIPTS) {
            this.rhinoEngine.evaluate(script, this.getResourceInputStream(baseJsLocation + script));
        }
    }

    private InputStream getResourceInputStream(String path) {
        InputStream is = this.config.getContext().getResourceAsStream(path);
        if (is == null) {
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException(e);
            }
        }
        return is;
    }

    public CompressionResult compress(String scriptSource) {
        Scriptable compileScope = this.rhinoEngine.newObject();
        compileScope.put("scriptSource", compileScope, (Object)scriptSource);
        try {
            Object result = this.rhinoEngine.evaluateString(compileScope, String.format("minify(scriptSource, %s);", this.optionsInJson), "uglify");
            CompressionResult minifierResult = (CompressionResult)Context.jsToJava((Object)result, CompressionResult.class);
            return minifierResult;
        }
        catch (JavaScriptException e) {
            throw new BundlingProcessException(e);
        }
    }
}

