/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl.yui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YUIErrorReporter
implements ErrorReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(YUIErrorReporter.class);
    private BundleProcessingStatus status;
    private StringBuffer bundleData;
    private int errorLine;
    private String yuiErrorMessage;

    public YUIErrorReporter(BundleProcessingStatus status, StringBuffer bundleData) {
        this.status = status;
        this.bundleData = bundleData;
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.errorLine < 1) {
            this.errorLine = line;
            this.yuiErrorMessage = message;
        } else if (this.errorLine == line) {
            this.yuiErrorMessage = this.yuiErrorMessage + "] [" + message;
        }
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        StringBuffer errorMsg = new StringBuffer("YUI failed to minify the bundle with id: '" + this.status.getCurrentBundle().getId() + "'.\n");
        errorMsg.append("YUI error message(s):[").append(this.yuiErrorMessage).append("]\n");
        errorMsg.append("The error happened at this point in your javascript: \n");
        errorMsg.append("_______________________________________________\n...\n");
        BufferedReader rd = new BufferedReader(new StringReader(this.bundleData.toString()));
        int totalLines = 0;
        int start = this.errorLine - 10;
        try {
            String s;
            while ((s = rd.readLine()) != null) {
                if (++totalLines < start || totalLines > this.errorLine) continue;
                errorMsg.append(s);
                if (totalLines == this.errorLine) {
                    errorMsg.append(" <-- ERROR");
                }
                errorMsg.append("\n");
            }
        }
        catch (IOException e) {
            errorMsg.append("[Jawr suffered an IOException while attempting to show the faulty script]");
        }
        errorMsg.append("_______________________________________________");
        errorMsg.append("\nIf you can't find the error, try to check the scripts using JSLint (http://www.jslint.com/) to find the conflicting part of the code.\n");
        return new EvaluatorException(errorMsg.toString(), this.status.getCurrentBundle().getName(), this.errorLine);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        }
    }
}

